/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saoui.api.entity.rendering;

import com.mojang.authlib.GameProfile;
import com.tencao.saomclib.Client;
import com.tencao.saoui.api.entity.rendering.ColorState;
import com.tencao.saoui.api.entity.rendering.IColorStateHandler;
import com.tencao.saoui.capabilities.RenderCapabilityKt;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tencao/saoui/api/entity/rendering/PlayerColorStateHandler;", "Lcom/tencao/saoui/api/entity/rendering/IColorStateHandler;", "thePlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "currentState", "Lcom/tencao/saoui/api/entity/rendering/ColorState;", "Ljava/lang/ref/WeakReference;", "tickForGamePlayCheck", "", "ticksForRedemption", "getColorState", "getInnocent", "hit", "", "target", "kill", "load", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "save", "tick", "Companion", "saoui"})
public final class PlayerColorStateHandler
implements IColorStateHandler {
    private final WeakReference<EntityPlayer> thePlayer;
    private int ticksForRedemption;
    private int tickForGamePlayCheck;
    private ColorState currentState;
    private static final String KEY;
    private static final int TICKS_PER_STATE = 12000;
    private static final UUID[] devs;
    public static final Companion Companion;

    @Override
    @NotNull
    public ColorState getColorState() {
        return this.currentState;
    }

    @Override
    public void tick() {
        PlayerColorStateHandler playerColorStateHandler = this;
        playerColorStateHandler.tickForGamePlayCheck += -1;
        if (playerColorStateHandler.tickForGamePlayCheck <= 0 && Client.INSTANCE.getMinecraft().func_147114_u() != null) {
            GameType gamemode;
            Object v6;
            block8: {
                NetHandlerPlayClient netHandlerPlayClient = Client.INSTANCE.getMinecraft().func_147114_u();
                if (netHandlerPlayClient == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)netHandlerPlayClient, (String)"Client.minecraft.connection!!");
                Collection collection = netHandlerPlayClient.func_175106_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Client.minecraft.connection!!.playerInfoMap");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NetworkPlayerInfo it = (NetworkPlayerInfo)element$iv;
                    boolean bl = false;
                    NetworkPlayerInfo networkPlayerInfo = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)networkPlayerInfo, (String)"it");
                    GameProfile gameProfile = networkPlayerInfo.func_178845_a();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gameProfile, (String)"it.gameProfile");
                    EntityPlayer entityPlayer = (EntityPlayer)this.thePlayer.get();
                    if (!Intrinsics.areEqual((Object)gameProfile.getId(), (Object)(entityPlayer != null ? entityPlayer.func_110124_au() : null))) continue;
                    v6 = element$iv;
                    break block8;
                }
                v6 = null;
            }
            NetworkPlayerInfo networkPlayerInfo = v6;
            Object object = gamemode = networkPlayerInfo != null ? networkPlayerInfo.func_178848_b() : null;
            if (gamemode != null) {
                this.currentState = gamemode.func_77145_d() ? ColorState.CREATIVE : (gamemode.func_77144_e() ? this.getInnocent() : ColorState.INVALID);
            }
            this.tickForGamePlayCheck = 20;
        }
        if (this.ticksForRedemption > 0) {
            PlayerColorStateHandler playerColorStateHandler2 = this;
            playerColorStateHandler2.ticksForRedemption += -1;
            if (playerColorStateHandler2.ticksForRedemption == 0) {
                if (this.currentState == ColorState.VIOLENT) {
                    this.currentState = this.getInnocent();
                } else {
                    this.currentState = ColorState.VIOLENT;
                    this.ticksForRedemption = 12000;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ColorState getInnocent() {
        ColorState colorState;
        if (this.thePlayer.get() != null) {
            Object t = this.thePlayer.get();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"thePlayer.get()!!");
            if (ArraysKt.contains((Object[])devs, (Object)((EntityPlayer)t).func_110124_au())) {
                colorState = ColorState.DEV;
                return colorState;
            }
        }
        colorState = ColorState.INNOCENT;
        return colorState;
    }

    public final void hit(@NotNull EntityPlayer target) {
        ColorState targetState;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Object object = RenderCapabilityKt.getRenderData((EntityLivingBase)target);
        ColorState colorState = object != null && (object = object.getColorStateHandler()) != null ? object.getColorState() : (targetState = null);
        if (targetState != ColorState.KILLER && targetState != ColorState.VIOLENT && this.currentState != ColorState.KILLER) {
            this.currentState = ColorState.VIOLENT;
            this.ticksForRedemption = 12000;
        }
    }

    public final void kill(@NotNull EntityPlayer target) {
        ColorState targetState;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Object object = RenderCapabilityKt.getRenderData((EntityLivingBase)target);
        ColorState colorState = object != null && (object = object.getColorStateHandler()) != null ? object.getColorState() : (targetState = null);
        if (targetState != ColorState.KILLER && targetState != ColorState.VIOLENT) {
            if (this.currentState == ColorState.KILLER) {
                this.ticksForRedemption += 12000;
            } else {
                this.currentState = ColorState.KILLER;
                this.ticksForRedemption = 12000;
            }
        }
    }

    @Override
    public void save(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagCompound atag = new NBTTagCompound();
        atag.func_74768_a("ticksForRedemption", this.ticksForRedemption);
        atag.func_74768_a("state", this.currentState.ordinal());
        tag.func_74782_a(KEY, (NBTBase)atag);
    }

    @Override
    public void load(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagCompound atag = tag.func_74775_l(KEY);
        this.ticksForRedemption = atag.func_74762_e("ticksForRedemption");
        this.currentState = ColorState.values()[atag.func_74762_e("state")];
    }

    public PlayerColorStateHandler(@NotNull EntityPlayer thePlayer) {
        Intrinsics.checkParameterIsNotNull((Object)thePlayer, (String)"thePlayer");
        this.thePlayer = new WeakReference<EntityPlayer>(thePlayer);
        this.currentState = this.getInnocent();
    }

    static {
        Companion = new Companion(null);
        String string = new ResourceLocation("saoui", "playerColorHandler").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ResourceLocation(SAOCore\u2026ColorHandler\").toString()");
        KEY = string;
        devs = new UUID[]{UUID.fromString("08197bad-1da1-48fd-82f1-9b388c49b6c9"), UUID.fromString("dc1bced1-26df-4c18-8eca-37484229ded1")};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/tencao/saoui/api/entity/rendering/PlayerColorStateHandler$Companion;", "", "()V", "KEY", "", "TICKS_PER_STATE", "", "devs", "", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "[Ljava/util/UUID;", "saoui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

