/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saoui.social.friends;

import com.tencao.saomclib.Client;
import com.tencao.saoui.config.ConfigHandler;
import com.tencao.saoui.social.StaticPlayerHelper;
import com.tencao.saoui.social.friends.FriendRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class FriendsHandler {
    private static FriendsHandler instance;
    private final File friendsFile;
    private final List<FriendRequest> friendRequests = new ArrayList<FriendRequest>();
    private String[] friends;

    private FriendsHandler(FMLPreInitializationEvent event) {
        this.friendsFile = new File(Client.INSTANCE.getMinecraft().field_71412_D.getAbsolutePath(), "saouifriends");
        if (!this.friendsFile.exists()) {
            this.writeFriends(this.friends);
        }
        this.friends = this.loadFriends();
    }

    public static FriendsHandler instance() {
        return instance;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        instance = new FriendsHandler(event);
    }

    public String[] loadFriends() {
        try {
            String[] friends;
            FileInputStream stream2 = new FileInputStream(this.friendsFile);
            if (stream2.available() != 0) {
                int count = stream2.read() & 0xFF;
                friends = new String[count];
                for (int i = 0; i < count; ++i) {
                    int length = stream2.read() & 0xFF;
                    byte[] bytes = new byte[length];
                    stream2.read(bytes, 0, length);
                    friends[i] = new String(bytes);
                }
            } else {
                friends = new String[]{};
            }
            stream2.close();
            return friends;
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public String[] listFriends() {
        if (this.friends == null) {
            this.friends = this.loadFriends();
        }
        return this.friends;
    }

    public boolean addFriends(EntityPlayer ... players) {
        this.friends = this.listFriends();
        ArrayList newNames = new ArrayList();
        Stream.of(players).map(EntityPlayer::getDisplayNameString).forEach(player -> {
            if (Stream.of(this.friends).noneMatch(friend -> friend.equals(player))) {
                newNames.add(player);
            }
        });
        String[] bb = new String[newNames.size()];
        System.arraycopy(newNames.toArray(new String[0]), 0, bb, 0, bb.length);
        return newNames.size() <= 0 || this.addRawFriends(bb);
    }

    public boolean isFriend(String name) {
        return Arrays.asList(this.listFriends()).contains(name);
    }

    public boolean isFriend(EntityPlayer player) {
        return this.isFriend(StaticPlayerHelper.INSTANCE.getName(player));
    }

    public boolean addRawFriends(String[] names) {
        this.friends = this.listFriends();
        String[] resized = new String[this.friends.length + names.length];
        System.arraycopy(this.friends, 0, resized, 0, this.friends.length);
        System.arraycopy(names, 0, resized, this.friends.length, names.length);
        if (this.writeFriends(resized)) {
            this.friends = resized;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeFriends(String[] friends) {
        String[] data = friends == null ? new String[]{} : friends;
        File file = this.friendsFile;
        synchronized (file) {
            try (FileOutputStream stream2 = new FileOutputStream(this.friendsFile);){
                int count = data.length % 256;
                stream2.write(count);
                for (int i = 0; i < count; ++i) {
                    byte[] bytes = data[i].getBytes();
                    int length = bytes.length % 256;
                    stream2.write(length);
                    stream2.write(bytes, 0, length);
                }
                stream2.flush();
                stream2.close();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (ConfigHandler.INSTANCE.getDEBUG()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptAddFriend(EntityPlayer player) {
        List<FriendRequest> list2 = this.friendRequests;
        synchronized (list2) {
            int index = -1;
            for (int i = 0; i < this.friendRequests.size(); ++i) {
                if (!this.friendRequests.get(i).equals(player.getDisplayNameString())) continue;
                index = i;
                break;
            }
            if (index >= 0 && (this.isFriend(player) || this.addFriends(player))) {
                this.friendRequests.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAddFriend(EntityPlayer player) {
        List<FriendRequest> list2 = this.friendRequests;
        synchronized (list2) {
            int index = -1;
            for (int i = 0; i < this.friendRequests.size(); ++i) {
                if (!this.friendRequests.get(i).equals(player.getDisplayNameString())) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                this.friendRequests.remove(index);
            }
        }
    }
}

