/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saoui.util;

import com.tencao.saoui.api.entity.ISkill;
import com.tencao.saoui.api.screens.Actions;
import com.tencao.saoui.api.screens.IIcon;
import com.tencao.saoui.events.EventHandler;
import com.tencao.saoui.util.IconCore;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public enum DefaultSkills implements ISkill
{
    SPRINTING(IconCore.SPRINTING, EventHandler.INSTANCE::getIS_SPRINTING, (mc, parent) -> EventHandler.INSTANCE.setIS_SPRINTING(!EventHandler.INSTANCE.getIS_SPRINTING())),
    SNEAKING(IconCore.SNEAKING, EventHandler.INSTANCE::getIS_SNEAKING, (mc, parent) -> EventHandler.INSTANCE.setIS_SNEAKING(!EventHandler.INSTANCE.getIS_SNEAKING())),
    CRAFTING(IconCore.CRAFTING, () -> false, (mc, parent) -> {
        if (parent != null) {
            mc.func_147108_a((GuiScreen)parent);
        } else {
            mc.func_147108_a(null);
            int invKeyCode = mc.field_71474_y.field_151445_Q.func_151463_i();
            KeyBinding.func_74510_a((int)invKeyCode, (boolean)true);
            KeyBinding.func_74507_a((int)invKeyCode);
        }
    });

    private final IIcon icon;
    private final BooleanSupplier shouldHighlight;
    private final BiConsumer<Minecraft, GuiInventory> action;
    private boolean showOnRing = true;

    private DefaultSkills(IIcon icon, BooleanSupplier shouldHighlight, BiConsumer<Minecraft, GuiInventory> action) {
        this.icon = icon;
        this.shouldHighlight = shouldHighlight;
        this.action = action;
    }

    @Override
    @NotNull
    public final String toString() {
        String name = this.name();
        return I18n.func_135052_a((String)("skill" + name.charAt(0) + name.substring(1).toLowerCase()), (Object[])new Object[0]);
    }

    @Override
    public boolean shouldHighlight() {
        return this.shouldHighlight.getAsBoolean();
    }

    @Override
    public boolean shouldShowInRing() {
        return this.showOnRing;
    }

    @Override
    public void activate(@NotNull Minecraft mc, @NotNull GuiInventory parent, @NotNull Actions action) {
        this.action.accept(mc, parent);
    }

    @Override
    @NotNull
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setShowOnRing(boolean showOnRing) {
        this.showOnRing = showOnRing;
    }

    @Override
    public boolean visible() {
        return true;
    }
}

