/*
 * Decompiled with CFR 0.152.
 */
package com.tencao.saoui.util;

import com.google.common.collect.Lists;
import com.tencao.saoui.SAOCore;
import com.tencao.saoui.config.ConfigHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

@Deprecated
public class UpdateChecker
extends Thread {
    private static final String curseURL = "http://minecraft.curseforge.com/projects/sao-ui/files";
    private static final String changelogURL = "https://raw.githubusercontent.com/Tencao/SAO-UI---1.10.2/master/Changelog.txt";
    private static boolean hasChecked;
    private static boolean hasUpdate;
    private static List<String> changes;

    public static boolean hasChecked() {
        return hasChecked;
    }

    public static boolean hasUpdate() {
        return hasUpdate;
    }

    public static List<String> fetchChangeLog() {
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        if (!hasChecked) {
            try {
                connection = (HttpURLConnection)new URL(changelogURL).openConnection();
                connection.connect();
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = reader.readLine();
                if (line == null) {
                    SAOCore.INSTANCE.getLOGGER().fatal("Update check failed!");
                    throw new IOException("No data from github changelog!");
                }
                changes = Lists.newArrayList();
                String latestVersion = line.substring(11);
                latestVersion = latestVersion.trim();
                if (ConfigHandler.INSTANCE.getLastVersion().equals(latestVersion) && ConfigHandler.INSTANCE.ignoreVersion()) {
                    hasChecked = true;
                    return;
                }
                if (!ConfigHandler.INSTANCE.getLastVersion().equals(latestVersion)) {
                    ConfigHandler.INSTANCE.saveVersion(latestVersion);
                    if (ConfigHandler.INSTANCE.ignoreVersion()) {
                        ConfigHandler.INSTANCE.setIgnoreVersion(false);
                    }
                }
                changes.add("A new update has been found\n \nChangelog:");
                while ((line = reader.readLine()) != null && !line.startsWith("###Version")) {
                    if (line.isEmpty()) continue;
                    line = line.substring(1).trim();
                    changes.add(line);
                }
                changes.add("\n \n To download, visit http://minecraft.curseforge.com/projects/sao-ui/files");
                if (!"2.1.9".equals(latestVersion)) {
                    hasUpdate = true;
                }
            }
            catch (Exception e) {
                SAOCore.INSTANCE.getLOGGER().fatal("Caught exception in Update Checker thread!");
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        SAOCore.INSTANCE.getLOGGER().fatal("Caught exception in Update Checker");
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
                hasChecked = true;
            }
        }
    }
}

