/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.base64;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.base64.Base64;
import saoui.shade.com.helger.commons.io.stream.WrappedInputStream;

@NotThreadSafe
public class Base64InputStream
extends WrappedInputStream {
    private final boolean m_bEncode;
    private int m_nPosition;
    private final byte[] m_aBuffer;
    private final int m_nBufferLength;
    private int m_nNumSigBytes;
    private int m_nLineLength;
    private final boolean m_bBreakLines;
    private final int m_nOptions;
    private final byte[] m_aDecodabet;

    public Base64InputStream(@Nonnull InputStream inputStream) {
        this(inputStream, 0);
    }

    public Base64InputStream(@Nonnull InputStream inputStream, int n) {
        super(inputStream);
        this.m_nOptions = n;
        this.m_bBreakLines = (n & 8) > 0;
        this.m_bEncode = (n & 1) > 0;
        this.m_nBufferLength = this.m_bEncode ? 4 : 3;
        this.m_aBuffer = new byte[this.m_nBufferLength];
        this.m_nPosition = -1;
        this.m_nLineLength = 0;
        this.m_aDecodabet = Base64._getDecodabet(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.m_nPosition < 0) {
            byte[] byArray;
            if (this.m_bEncode) {
                int n;
                byArray = new byte[3];
                int n2 = 0;
                for (int i = 0; i < 3 && (n = this.in.read()) >= 0; ++i) {
                    byArray[i] = (byte)n;
                    ++n2;
                }
                if (n2 <= 0) return -1;
                Base64._encode3to4(byArray, 0, n2, this.m_aBuffer, 0, this.m_nOptions);
                this.m_nPosition = 0;
                this.m_nNumSigBytes = 4;
            } else {
                int n;
                byArray = new byte[4];
                for (n = 0; n < 4; ++n) {
                    int n3;
                    while ((n3 = this.in.read()) >= 0 && this.m_aDecodabet[n3 & 0x7F] <= -5) {
                    }
                    if (n3 < 0) break;
                    byArray[n] = (byte)n3;
                }
                if (n == 4) {
                    this.m_nNumSigBytes = Base64._decode4to3(byArray, 0, this.m_aBuffer, 0, this.m_nOptions);
                    this.m_nPosition = 0;
                } else {
                    if (n != 0) throw new IOException("Improperly padded Base64 input.");
                    return -1;
                }
            }
        }
        if (this.m_nPosition < 0) throw new IOException("Error in Base64 code reading stream.");
        if (this.m_nPosition >= this.m_nNumSigBytes) {
            return -1;
        }
        if (this.m_bEncode && this.m_bBreakLines && this.m_nLineLength >= 76) {
            this.m_nLineLength = 0;
            return 10;
        }
        ++this.m_nLineLength;
        byte by = this.m_aBuffer[this.m_nPosition++];
        if (this.m_nPosition < this.m_nBufferLength) return by & 0xFF;
        this.m_nPosition = -1;
        return by & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 < 0) {
                if (n3 != 0) break;
                return -1;
            }
            byArray[n + n3] = (byte)n4;
        }
        return n3;
    }
}

