/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.base64;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.base64.Base64;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.io.stream.WrappedOutputStream;

@NotThreadSafe
public class Base64OutputStream
extends WrappedOutputStream {
    private final boolean m_bEncode;
    private int m_nPosition;
    private byte[] m_aBuffer;
    private final int m_nBufferLength;
    private int m_nLineLength;
    private final boolean m_bBreakLines;
    private final byte[] m_aB4;
    private boolean m_bSuspendEncoding;
    private final int m_nOptions;
    private final byte[] m_aDecodabet;
    private byte[] m_aNewLineBytes = new byte[]{10};

    public Base64OutputStream(@Nonnull OutputStream outputStream) {
        this(outputStream, 1);
    }

    public Base64OutputStream(@Nonnull OutputStream outputStream, int n) {
        super(outputStream);
        this.m_bBreakLines = (n & 8) != 0;
        this.m_bEncode = (n & 1) != 0;
        this.m_nBufferLength = this.m_bEncode ? 3 : 4;
        this.m_aBuffer = new byte[this.m_nBufferLength];
        this.m_nPosition = 0;
        this.m_nLineLength = 0;
        this.m_bSuspendEncoding = false;
        this.m_aB4 = new byte[4];
        this.m_nOptions = n;
        this.m_aDecodabet = Base64._getDecodabet(n);
    }

    public void setNewLineBytes(@Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty(byArray, "NewLineBytes");
        this.m_aNewLineBytes = ArrayHelper.getCopy(byArray);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_bSuspendEncoding) {
            this.out.write(n);
            return;
        }
        if (this.m_bEncode) {
            this.m_aBuffer[this.m_nPosition++] = (byte)n;
            if (this.m_nPosition >= this.m_nBufferLength) {
                this.out.write(Base64._encode3to4(this.m_aB4, this.m_aBuffer, this.m_nBufferLength, this.m_nOptions));
                this.m_nLineLength += 4;
                if (this.m_bBreakLines && this.m_nLineLength >= 76) {
                    this.out.write(this.m_aNewLineBytes);
                    this.m_nLineLength = 0;
                }
                this.m_nPosition = 0;
            }
        } else if (this.m_aDecodabet[n & 0x7F] > -5) {
            this.m_aBuffer[this.m_nPosition++] = (byte)n;
            if (this.m_nPosition >= this.m_nBufferLength) {
                int n2 = Base64._decode4to3(this.m_aBuffer, 0, this.m_aB4, 0, this.m_nOptions);
                this.out.write(this.m_aB4, 0, n2);
                this.m_nPosition = 0;
            }
        } else if (this.m_aDecodabet[n & 0x7F] != -5) {
            throw new IOException("Invalid character in Base64 data.");
        }
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        if (this.m_bSuspendEncoding) {
            this.out.write(byArray, n, n2);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void flushBase64() throws IOException {
        if (this.m_nPosition > 0) {
            if (this.m_bEncode) {
                this.out.write(Base64._encode3to4(this.m_aB4, this.m_aBuffer, this.m_nPosition, this.m_nOptions));
                this.m_nPosition = 0;
            } else {
                throw new IOException("Base64 input not properly padded.");
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBase64();
        if (this.out != null) {
            super.close();
        }
        this.m_aBuffer = null;
        this.out = null;
    }

    public void suspendEncoding() throws IOException {
        this.flushBase64();
        this.m_bSuspendEncoding = true;
    }

    public void resumeEncoding() {
        this.m_bSuspendEncoding = false;
    }
}

