/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsMap;
import saoui.shade.com.helger.commons.state.ETriState;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class AnnotationUsageCache {
    private final Class<? extends Annotation> m_aAnnotationClass;
    private final ICommonsMap<String, ETriState> m_aMap = new CommonsHashMap<String, ETriState>();

    public AnnotationUsageCache(@Nonnull Class<? extends Annotation> clazz) {
        RetentionPolicy retentionPolicy;
        ValueEnforcer.notNull(clazz, "AnnotationClass");
        Retention retention = clazz.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy2 = retentionPolicy = retention == null ? RetentionPolicy.CLASS : retention.value();
        if (retentionPolicy != RetentionPolicy.RUNTIME) {
            throw new IllegalArgumentException("RetentionPolicy must be of type RUNTIME to be used within this cache. The current value ist " + (Object)((Object)retentionPolicy));
        }
        this.m_aAnnotationClass = clazz;
    }

    @Nonnull
    public final Class<? extends Annotation> getAnnotationClass() {
        return this.m_aAnnotationClass;
    }

    public boolean hasAnnotation(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        return this.hasAnnotation(object.getClass());
    }

    public boolean hasAnnotation(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        ETriState eTriState = (ETriState)this.m_aMap.get(string);
        if (eTriState == null) {
            eTriState = ETriState.valueOf(clazz.getAnnotation(this.m_aAnnotationClass) != null);
            this.m_aMap.put(string, eTriState);
        }
        return eTriState.isTrue();
    }

    public void setAnnotation(@Nonnull Class<?> clazz, boolean bl) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        this.m_aMap.put(string, ETriState.valueOf(bl));
    }

    public void clearCache() {
        this.m_aMap.clear();
    }

    public String toString() {
        return new ToStringGenerator(this).append("AnnotationClass", this.m_aAnnotationClass).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ ETriState lambda$hasAnnotation$0(Class clazz, String string) {
        return ETriState.valueOf(clazz.getAnnotation(this.m_aAnnotationClass) != null);
    }
}

