/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.callback;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.callback.ICallback;
import saoui.shade.com.helger.commons.callback.ICallbackList;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedSet;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.lang.ICloneable;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.state.EContinue;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public class CallbackList<CALLBACKTYPE extends ICallback>
implements ICallbackList<CALLBACKTYPE>,
ICloneable<CallbackList<CALLBACKTYPE>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallbackList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedSet<CALLBACKTYPE> m_aCallbacks = new CommonsLinkedHashSet<CALLBACKTYPE>();

    public CallbackList() {
    }

    public CallbackList(@Nullable CallbackList<CALLBACKTYPE> callbackList) {
        if (callbackList != null) {
            this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
        }
    }

    @Nonnull
    public EChange set(@Nonnull CallbackList<CALLBACKTYPE> callbackList) {
        ValueEnforcer.notNull(callbackList, "rhs");
        return this.m_aRWLock.writeLockedGet(() -> this.m_aCallbacks.setAll((Iterable<CALLBACKTYPE>)callbackList.m_aCallbacks));
    }

    @Nonnull
    public EChange set(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLockedGet(() -> this.m_aCallbacks.set(CALLBACKTYPE));
    }

    @Nonnull
    public EChange add(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLockedGet(() -> this.m_aCallbacks.addObject(CALLBACKTYPE));
    }

    @Nonnull
    @SafeVarargs
    public final EChange addAll(CALLBACKTYPE ... CALLBACKTYPEArray) {
        ValueEnforcer.notNullNoNullValue(CALLBACKTYPEArray, "Callbacks");
        return this.m_aRWLock.writeLockedGet(() -> this.m_aCallbacks.addAll(CALLBACKTYPEArray));
    }

    @Nonnull
    public EChange removeObject(@Nullable CALLBACKTYPE CALLBACKTYPE) {
        if (CALLBACKTYPE == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLockedGet(() -> this.m_aCallbacks.removeObject(CALLBACKTYPE));
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aRWLock.writeLockedGet(this.m_aCallbacks::removeAll);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CALLBACKTYPE> getAllCallbacks() {
        this.m_aRWLock.readLock().lock();
        try {
            ICommonsList iCommonsList = this.m_aCallbacks.getCopyAsList();
            return iCommonsList;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public CALLBACKTYPE getCallbackAtIndex(@Nonnegative int n) {
        return (CALLBACKTYPE)this.m_aRWLock.readLockedGet(() -> (ICallback)this.m_aCallbacks.getAtIndex(n));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(this.m_aCallbacks::size);
    }

    @Override
    public boolean isEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aCallbacks.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public CallbackList<CALLBACKTYPE> getClone() {
        return this.m_aRWLock.readLockedGet(() -> new CallbackList<CALLBACKTYPE>(this));
    }

    @Override
    @Nonnull
    public Iterator<CALLBACKTYPE> iterator() {
        return this.m_aRWLock.readLockedGet(this.m_aCallbacks::iterator);
    }

    @Override
    public void forEach(@Nonnull Consumer<? super CALLBACKTYPE> consumer) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                consumer.accept(iCallback);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke callback " + iCallback, exception);
            }
        }
    }

    @Override
    @Nonnull
    public EContinue forEachBreakable(@Nonnull Function<? super CALLBACKTYPE, EContinue> function) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                if (!function.apply(iCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke callback " + iCallback, exception);
            }
        }
        return EContinue.CONTINUE;
    }

    public String toString() {
        return new ToStringGenerator(this).append("callbacks", this.m_aCallbacks).getToString();
    }
}

