/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.charset;

import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.charset.CharsetHelper;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.io.ByteArrayWrapper;

public enum EUnicodeBOM {
    BOM_UTF_32_BIG_ENDIAN(new byte[]{0, 0, -2, -1}, "utf-32be"),
    BOM_UTF_32_LITTLE_ENDIAN(new byte[]{-1, -2, 0, 0}, "utf-32le"),
    BOM_UTF_7(new byte[]{43, 47, 118, 56}, "utf-7"),
    BOM_UTF_7_ALT2(new byte[]{43, 47, 118, 57}, "utf-7"),
    BOM_UTF_7_ALT3(new byte[]{43, 47, 118, 43}, "utf-7"),
    BOM_UTF_7_ALT4(new byte[]{43, 47, 118, 47}, "utf-7"),
    BOM_UTF_EBCDIC(new byte[]{-35, 115, 102, 115}, null),
    BOM_BOCU_1_ALT2(new byte[]{-5, -18, 40, -1}, null),
    BOM_GB_18030(new byte[]{-124, 49, -107, 51}, "gb18030"),
    BOM_UTF_8(new byte[]{-17, -69, -65}, "utf-8"),
    BOM_UTF_1(new byte[]{-9, 100, 76}, "utf-1"),
    BOM_BOCU_1(new byte[]{-5, -18, 40}, null),
    BOM_SCSU(new byte[]{14, -2, -1}, null),
    BOM_SCSU_TO_UCS(new byte[]{15, -2, -1}, null),
    BOM_SCSU_W0_TO_FE80(new byte[]{24, -91, -1}, null),
    BOM_SCSU_W1_TO_FE80(new byte[]{25, -91, -1}, null),
    BOM_SCSU_W2_TO_FE80(new byte[]{26, -91, -1}, null),
    BOM_SCSU_W3_TO_FE80(new byte[]{27, -91, -1}, null),
    BOM_SCSU_W4_TO_FE80(new byte[]{28, -91, -1}, null),
    BOM_SCSU_W5_TO_FE80(new byte[]{29, -91, -1}, null),
    BOM_SCSU_W6_TO_FE80(new byte[]{30, -91, -1}, null),
    BOM_SCSU_W7_TO_FE80(new byte[]{31, -91, -1}, null),
    BOM_UTF_16_BIG_ENDIAN(new byte[]{-2, -1}, "utf-16be"),
    BOM_UTF_16_LITTLE_ENDIAN(new byte[]{-1, -2}, "utf-16le");

    private static final int MAXIMUM_BOM_BYTE_COUNT = 4;
    private final ByteArrayWrapper m_aBOMBytes;
    private final String m_sCharsetName;
    private final Charset m_aCharset;

    private EUnicodeBOM(byte[] byArray, String string2) {
        ValueEnforcer.isBetweenInclusive(byArray.length, "Byte count", 1, 4);
        this.m_aBOMBytes = new ByteArrayWrapper(byArray, false);
        this.m_sCharsetName = string2;
        this.m_aCharset = CharsetHelper.getCharsetFromNameOrNull(string2);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getAllBytes() {
        return this.m_aBOMBytes.getAllBytes();
    }

    @Nonnegative
    public int getByteCount() {
        return this.m_aBOMBytes.size();
    }

    public boolean isPresent(@Nullable byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        return ArrayHelper.startsWith(byArray, this.m_aBOMBytes.bytes());
    }

    @Nullable
    public String getCharsetName() {
        return this.m_sCharsetName;
    }

    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    public boolean hasCharset() {
        return this.m_aCharset != null;
    }

    @Nonnegative
    public static int getMaximumByteCount() {
        return 4;
    }

    @Nullable
    public static EUnicodeBOM getFromBytesOrNull(@Nullable byte[] byArray) {
        if (ArrayHelper.isNotEmpty(byArray)) {
            for (EUnicodeBOM eUnicodeBOM : EUnicodeBOM.values()) {
                if (!eUnicodeBOM.isPresent(byArray)) continue;
                return eUnicodeBOM;
            }
        }
        return null;
    }
}

