/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.codec;

import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.codec.ICharArrayDecoder;
import saoui.shade.com.helger.commons.io.stream.NonBlockingStringWriter;

@FunctionalInterface
public interface ICharArrayStreamDecoder
extends ICharArrayDecoder {
    default public void decode(@Nullable char[] cArray, @Nonnull @WillNotClose Writer writer) {
        if (cArray == null) {
            this.decode(null, 0, 0, writer);
        } else {
            this.decode(cArray, 0, cArray.length, writer);
        }
    }

    public void decode(@Nullable char[] var1, @Nonnegative int var2, @Nonnegative int var3, @Nonnull @WillNotClose Writer var4);

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public char[] getDecoded(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            char[] cArray2 = nonBlockingStringWriter.getAsCharArray();
            return cArray2;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }

    @Nullable
    default public String getDecodedAsString(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }
}

