/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.collection;

import java.util.Collection;
import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@NotThreadSafe
public class NonBlockingStack<ELEMENTTYPE>
extends CommonsArrayList<ELEMENTTYPE> {
    public NonBlockingStack() {
    }

    public NonBlockingStack(@Nonnegative int n) {
        super(n);
    }

    @SafeVarargs
    public NonBlockingStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this.addAll(ELEMENTTYPEArray);
    }

    public NonBlockingStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public NonBlockingStack(@Nullable NonBlockingStack<? extends ELEMENTTYPE> nonBlockingStack) {
        if (nonBlockingStack != null) {
            this.addAll(nonBlockingStack);
        }
    }

    @Nullable
    public ELEMENTTYPE push(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.add(ELEMENTTYPE);
        return ELEMENTTYPE;
    }

    @Nullable
    public ELEMENTTYPE pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.removeLast();
    }

    @Nullable
    public ELEMENTTYPE peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.getLast();
    }

    @Nullable
    public ELEMENTTYPE top() {
        return this.peek();
    }

    @Nullable
    public ELEMENTTYPE firstElement() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (ELEMENTTYPE)this.getFirst();
    }

    @Nullable
    public ELEMENTTYPE replaceTopElement(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.setLast(ELEMENTTYPE);
        return ELEMENTTYPE;
    }

    @Override
    @Nonnull
    public NonBlockingStack<ELEMENTTYPE> getClone() {
        return new NonBlockingStack<ELEMENTTYPE>(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(super.hashCode()).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("list", super.toString()).getToString();
    }
}

