/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.collection.impl;

import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.CollectionHelper;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashMap;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedSet;
import saoui.shade.com.helger.commons.collection.map.MapEntry;

public interface ICommonsOrderedMap<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <K, V> ICommonsOrderedMap<K, V> createInstance() {
        return new CommonsLinkedHashMap();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsLinkedHashSet(this.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CollectionHelper.newOrderedSet(this.keySet(), predicate);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            commonsLinkedHashSet.add(new MapEntry(entry));
        }
        return commonsLinkedHashSet;
    }

    @Nullable
    default public KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    @Nullable
    default public KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : CollectionHelper.getLastElement(this.keySet()));
    }

    @Nullable
    default public VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    @Nullable
    default public VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        KEYTYPE KEYTYPE = this.getLastKey();
        return (VALUETYPE)(KEYTYPE == null ? VALUETYPE : this.get(KEYTYPE));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<KEYTYPE, VALUETYPE> getClone();
}

