/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.compare;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.cache.Cache;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.system.SystemHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class CollatorHelper {
    private static final CollatorCache COLLATOR_CACHE = new CollatorCache();
    private static final CollatorHelper INSTANCE = new CollatorHelper();

    private CollatorHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Collator getCollatorSpaceBeforeDot(@Nullable Locale locale) {
        Locale locale2 = locale == null ? SystemHelper.getSystemLocale() : locale;
        return (Collator)((Collator)COLLATOR_CACHE.getFromCache(locale2)).clone();
    }

    @Nonnull
    public static EChange clearCache() {
        return COLLATOR_CACHE.clearCache();
    }

    @ThreadSafe
    private static final class CollatorCache
    extends Cache<Locale, Collator> {
        private static final Logger LOGGER = LoggerFactory.getLogger(CollatorCache.class);

        public CollatorCache() {
            super(locale -> {
                if (locale == null) {
                    LOGGER.error("Very weird: no locale passed in. Falling back to system locale.");
                    return Collator.getInstance(SystemHelper.getSystemLocale());
                }
                Collator collator = Collator.getInstance(locale);
                if (!(collator instanceof RuleBasedCollator)) {
                    LOGGER.warn("Collator.getInstance did not return a RulleBasedCollator but a " + collator.getClass().getName());
                    return collator;
                }
                try {
                    String string = ((RuleBasedCollator)collator).getRules();
                    if (!string.contains("<'.'<")) {
                        LOGGER.warn("Failed to identify the Collator rule part to be replaced. Locale used: " + locale);
                        return collator;
                    }
                    String string2 = StringHelper.replaceAll(string, "<'.'<", "<' '<'.'<");
                    RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(string2);
                    ruleBasedCollator.setStrength(2);
                    ruleBasedCollator.setDecomposition(2);
                    return ruleBasedCollator;
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException("Failed to parse collator rule set for locale " + locale, parseException);
                }
            }, 500, CollatorHelper.class.getName());
        }
    }
}

