/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.compare;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.compare.CollatorHelper;
import saoui.shade.com.helger.commons.equals.EqualsHelper;

@Immutable
public final class CompareHelper {
    public static final boolean DEFAULT_NULL_VALUES_COME_FIRST = true;
    private static final CompareHelper INSTANCE = new CompareHelper();

    private CompareHelper() {
    }

    public static int compareTrueBeforeFalse(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        return bl ? 1 : -1;
    }

    public static int compareFalseBeforeTrue(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        return bl ? -1 : 1;
    }

    public static int compare(byte by, byte by2) {
        return Byte.compare(by, by2);
    }

    public static int compare(char c, char c2) {
        return Character.compare(c, c2);
    }

    public static int compare(double d, double d2) {
        return Double.compare(d, d2);
    }

    public static int compare(float f, float f2) {
        return Float.compare(f, f2);
    }

    public static int compare(int n, int n2) {
        return Integer.compare(n, n2);
    }

    public static int compare(long l, long l2) {
        return Long.compare(l, l2);
    }

    public static int compare(short s, short s2) {
        return Short.compare(s, s2);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2) {
        return CompareHelper.compare(DATATYPE, DATATYPE2, true);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, boolean bl) {
        if (EqualsHelper.identityEqual(DATATYPE, DATATYPE2)) {
            return 0;
        }
        if (DATATYPE == null) {
            return bl ? -1 : 1;
        }
        if (DATATYPE2 == null) {
            return bl ? 1 : -1;
        }
        return DATATYPE.compareTo(DATATYPE2);
    }

    public static <DATATYPE> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<? super DATATYPE> comparator) {
        return CompareHelper.compare(DATATYPE, DATATYPE2, comparator, true);
    }

    public static <DATATYPE> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<? super DATATYPE> comparator, boolean bl) {
        if (EqualsHelper.identityEqual(DATATYPE, DATATYPE2)) {
            return 0;
        }
        if (DATATYPE == null) {
            return bl ? -1 : 1;
        }
        if (DATATYPE2 == null) {
            return bl ? 1 : -1;
        }
        return comparator.compare(DATATYPE, DATATYPE2);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return CompareHelper.compare(string, string2, locale, true);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale, boolean bl) {
        return CompareHelper.compare(string, string2, CollatorHelper.getCollatorSpaceBeforeDot(locale), bl);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator) {
        return CompareHelper.compare(string, string2, collator, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator, boolean bl) {
        if (EqualsHelper.identityEqual(string, string2)) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return collator.compare(string, string2);
    }

    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2) {
        return CompareHelper.compareIgnoreCase(string, string2, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2, boolean bl) {
        if (EqualsHelper.identityEqual(string, string2)) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return string.compareToIgnoreCase(string2);
    }
}

