/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.compare;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.compare.CollatorHelper;
import saoui.shade.com.helger.commons.compare.CompareHelper;

@FunctionalInterface
@NotThreadSafe
public interface IComparator<DATATYPE>
extends Comparator<DATATYPE>,
Serializable {
    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nullable Locale locale) {
        return IComparator.getComparatorCollating(CollatorHelper.getCollatorSpaceBeforeDot(locale));
    }

    @Nonnull
    public static Comparator<String> getComparatorCollating(@Nonnull Collator collator) {
        ValueEnforcer.notNull(collator, "Collator");
        return Comparator.nullsFirst(collator::compare);
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nullable Locale locale) {
        return Comparator.comparing(function, IComparator.getComparatorCollating(locale));
    }

    @Nonnull
    public static <T> Comparator<T> getComparatorCollating(@Nonnull Function<? super T, String> function, @Nonnull Collator collator) {
        return Comparator.comparing(function, IComparator.getComparatorCollating(collator));
    }

    @Nonnull
    public static IComparator<String> getComparatorStringLongestFirst() {
        return IComparator.getComparatorStringLongestFirst(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringLongestFirst(boolean bl) {
        return (string3, string4) -> CompareHelper.compare(string3, string4, (string, string2) -> {
            int n = string2.length() - string.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, bl);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringShortestFirst() {
        return IComparator.getComparatorStringShortestFirst(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringShortestFirst(boolean bl) {
        return (string3, string4) -> CompareHelper.compare(string3, string4, (string, string2) -> {
            int n = string.length() - string2.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, bl);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringIgnoreCase() {
        return IComparator.getComparatorStringIgnoreCase(true);
    }

    @Nonnull
    public static IComparator<String> getComparatorStringIgnoreCase(boolean bl) {
        return (string, string2) -> CompareHelper.compareIgnoreCase(string, string2, bl);
    }
}

