/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.concurrent;

import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.callback.IThrowingRunnable;
import saoui.shade.com.helger.commons.functional.IThrowingSupplier;

public class SimpleLock
extends ReentrantLock {
    public SimpleLock() {
    }

    public SimpleLock(boolean bl) {
        super(bl);
    }

    public void locked(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public <EXTYPE extends Exception> void lockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public <T> T lockedGet(@Nonnull Supplier<? extends T> supplier) {
        ValueEnforcer.notNull(supplier, "Supplier");
        this.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    public <T, EXTYPE extends Exception> T lockedGetThrowing(@Nonnull IThrowingSupplier<? extends T, EXTYPE> iThrowingSupplier) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingSupplier, "Callable");
        this.lock();
        try {
            T t = iThrowingSupplier.get();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    public boolean lockedBoolean(@Nonnull BooleanSupplier booleanSupplier) {
        ValueEnforcer.notNull(booleanSupplier, "Supplier");
        this.lock();
        try {
            boolean bl = booleanSupplier.getAsBoolean();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double lockedDouble(@Nonnull DoubleSupplier doubleSupplier) {
        ValueEnforcer.notNull(doubleSupplier, "Supplier");
        this.lock();
        try {
            double d = doubleSupplier.getAsDouble();
            return d;
        }
        finally {
            this.unlock();
        }
    }

    public int lockedInt(@Nonnull IntSupplier intSupplier) {
        ValueEnforcer.notNull(intSupplier, "Supplier");
        this.lock();
        try {
            int n = intSupplier.getAsInt();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lockedLong(@Nonnull LongSupplier longSupplier) {
        ValueEnforcer.notNull(longSupplier, "Supplier");
        this.lock();
        try {
            long l = longSupplier.getAsLong();
            return l;
        }
        finally {
            this.unlock();
        }
    }
}

