/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.state.ESuccess;

@Immutable
public final class ThreadHelper {
    private ThreadHelper() {
    }

    @Nonnull
    public static ESuccess sleepMinutes(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Minutes");
        return ThreadHelper.sleep(l * 60000L);
    }

    @Nonnull
    public static ESuccess sleepSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Seconds");
        return ThreadHelper.sleep(l * 1000L);
    }

    @Nonnull
    public static ESuccess sleep(@Nonnull Duration duration) {
        ValueEnforcer.notNull(duration, "Duration");
        return ThreadHelper.sleep(duration.toMillis());
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        ValueEnforcer.isGE0(l, "Duration");
        ValueEnforcer.notNull(timeUnit, "TimeUnit");
        return ThreadHelper.sleep(timeUnit.toMillis(l));
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "MilliSeconds");
        try {
            Thread.sleep(l);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ESuccess.FAILURE;
        }
    }
}

