/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.concurrent.collector;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import saoui.shade.com.helger.commons.concurrent.collector.IConcurrentPerformer;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.lang.GenericReflection;
import saoui.shade.com.helger.commons.state.ESuccess;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

public class ConcurrentCollectorMultiple<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_PERFORM_COUNT = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentCollectorMultiple.class);
    @Nonnegative
    private final int m_nMaxPerformCount;
    private IConcurrentPerformer<List<DATATYPE>> m_aPerformer;

    public ConcurrentCollectorMultiple() {
        this(100, 50);
    }

    public ConcurrentCollectorMultiple(@Nonnegative int n, @Nonnegative int n2) {
        super(n);
        ValueEnforcer.isGT0(n2, "MaxPerformCount");
        ValueEnforcer.isTrue(n2 <= n, () -> "max perform size is illegal " + n2 + " - must be <= queue size " + n);
        this.m_nMaxPerformCount = n2;
    }

    public ConcurrentCollectorMultiple(@Nonnull BlockingQueue<Object> blockingQueue) {
        this(blockingQueue, 50);
    }

    public ConcurrentCollectorMultiple(@Nonnull BlockingQueue<Object> blockingQueue, @Nonnegative int n) {
        super(blockingQueue);
        this.m_nMaxPerformCount = ValueEnforcer.isGT0(n, "MaxPerformCount");
    }

    @Nonnegative
    public final int getMaxPerformCount() {
        return this.m_nMaxPerformCount;
    }

    @Nullable
    public final IConcurrentPerformer<List<DATATYPE>> getPerformer() {
        return this.m_aPerformer;
    }

    @Nonnull
    public final ConcurrentCollectorMultiple<DATATYPE> setPerformer(@Nonnull IConcurrentPerformer<List<DATATYPE>> iConcurrentPerformer) {
        if (this.m_aPerformer != null) {
            throw new IllegalStateException("Another performer is already set!");
        }
        this.m_aPerformer = ValueEnforcer.notNull(iConcurrentPerformer, "Performer");
        return this;
    }

    @Nonnull
    private ESuccess _perform(@Nonnull List<DATATYPE> list2) {
        if (!list2.isEmpty()) {
            try {
                this.m_aPerformer.runAsync(list2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to perform actions on " + list2.size() + " objects with performer " + this.m_aPerformer + " - objects are lost!", exception);
                return ESuccess.FAILURE;
            }
            list2.clear();
        }
        return ESuccess.SUCCESS;
    }

    @Override
    public final void collect() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            boolean bl = false;
            while (!EqualsHelper.identityEqual(e = this.m_aQueue.take(), STOP_QUEUE_OBJECT)) {
                commonsArrayList.add(GenericReflection.uncheckedCast(e));
                while (commonsArrayList.size() < this.m_nMaxPerformCount && !this.m_aQueue.isEmpty()) {
                    e = this.m_aQueue.take();
                    if (EqualsHelper.identityEqual(e, STOP_QUEUE_OBJECT)) {
                        bl = true;
                        break;
                    }
                    commonsArrayList.add(GenericReflection.uncheckedCast(e));
                }
                this._perform(commonsArrayList);
                if (!bl) continue;
                break;
            }
            this._perform(commonsArrayList);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error taking elements from queue - queue has been interrupted!!!", interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            LOGGER.error("Error taking elements from queue - queue has been interrupted!!!", exception);
        }
    }
}

