/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsIterable;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.csv.CSVIterator;
import saoui.shade.com.helger.commons.csv.CSVLineReaderKeepCR;
import saoui.shade.com.helger.commons.csv.CSVLineReaderNonBlockingBufferedReader;
import saoui.shade.com.helger.commons.csv.CSVParser;
import saoui.shade.com.helger.commons.csv.ICSVLineReader;
import saoui.shade.com.helger.commons.io.stream.NonBlockingBufferedReader;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;

public class CSVReader
implements Closeable,
ICommonsIterable<ICommonsList<String>> {
    private final Reader m_aReader;
    private final ICSVLineReader m_aLineReader;
    private final CSVParser m_aParser;
    private int m_nSkipLines = 0;
    private final boolean m_bKeepCR;
    private boolean m_bVerifyReader = true;
    private boolean m_bHasNext = true;
    private boolean m_bLinesSkiped = false;

    public CSVReader(@Nonnull @WillCloseWhenClosed Reader reader) {
        this(reader, new CSVParser(), false);
    }

    public CSVReader(@Nonnull @WillCloseWhenClosed Reader reader, boolean bl) {
        this(reader, new CSVParser(), bl);
    }

    public CSVReader(@Nonnull @WillCloseWhenClosed Reader reader, @Nonnull CSVParser cSVParser, boolean bl) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cSVParser, "Parser");
        Reader reader2 = StreamHelper.getBuffered(reader);
        if (bl) {
            this.m_aLineReader = new CSVLineReaderKeepCR(reader2);
        } else {
            if (!(reader2 instanceof NonBlockingBufferedReader)) {
                reader2 = new NonBlockingBufferedReader(reader2);
            }
            this.m_aLineReader = new CSVLineReaderNonBlockingBufferedReader((NonBlockingBufferedReader)reader2);
        }
        this.m_aReader = reader2;
        this.m_aParser = cSVParser;
        this.m_bKeepCR = bl;
    }

    @Nonnull
    public CSVParser getParser() {
        return this.m_aParser;
    }

    public char getSeparatorChar() {
        return this.m_aParser.getSeparatorChar();
    }

    @Nonnull
    public CSVReader setSeparatorChar(char c) {
        this.m_aParser.setSeparatorChar(c);
        return this;
    }

    public char getQuoteChar() {
        return this.m_aParser.getQuoteChar();
    }

    @Nonnull
    public CSVReader setQuoteChar(char c) {
        this.m_aParser.setQuoteChar(c);
        return this;
    }

    public char getEscapeChar() {
        return this.m_aParser.getEscapeChar();
    }

    @Nonnull
    public CSVReader setEscapeChar(char c) {
        this.m_aParser.setEscapeChar(c);
        return this;
    }

    public boolean isStrictQuotes() {
        return this.m_aParser.isStrictQuotes();
    }

    @Nonnull
    public CSVReader setStrictQuotes(boolean bl) {
        this.m_aParser.setStrictQuotes(bl);
        return this;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.m_aParser.isIgnoreLeadingWhiteSpace();
    }

    @Nonnull
    public CSVReader setIgnoreLeadingWhiteSpace(boolean bl) {
        this.m_aParser.setIgnoreLeadingWhiteSpace(bl);
        return this;
    }

    public boolean isIgnoreQuotations() {
        return this.m_aParser.isIgnoreQuotations();
    }

    @Nonnull
    public CSVReader setIgnoreQuotations(boolean bl) {
        this.m_aParser.setIgnoreQuotations(bl);
        return this;
    }

    @Nonnegative
    public int getSkipLines() {
        return this.m_nSkipLines;
    }

    @Nonnull
    public CSVReader setSkipLines(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "SkipLines");
        this.m_nSkipLines = n;
        return this;
    }

    public boolean isKeepCarriageReturns() {
        return this.m_bKeepCR;
    }

    public boolean isVerifyReader() {
        return this.m_bVerifyReader;
    }

    @Nonnull
    public CSVReader setVerifyReader(boolean bl) {
        this.m_bVerifyReader = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICommonsList<String>> readAll() throws IOException {
        CommonsArrayList<ICommonsList<String>> commonsArrayList = new CommonsArrayList<ICommonsList<String>>();
        while (this.m_bHasNext) {
            ICommonsList<String> iCommonsList = this.readNext();
            if (iCommonsList == null) continue;
            commonsArrayList.add(iCommonsList);
        }
        return commonsArrayList;
    }

    public void readAll(@Nonnull Consumer<? super ICommonsList<String>> consumer) throws IOException {
        while (this.m_bHasNext) {
            ICommonsList<String> iCommonsList = this.readNext();
            if (iCommonsList == null) continue;
            consumer.accept(iCommonsList);
        }
    }

    @Nullable
    public ICommonsList<String> readNext() throws IOException {
        ICommonsList<String> iCommonsList = null;
        do {
            String string = this._getNextLine();
            if (!this.m_bHasNext) {
                return iCommonsList;
            }
            ICommonsList<String> iCommonsList2 = this.m_aParser.parseLineMulti(string);
            if (iCommonsList == null) {
                iCommonsList = iCommonsList2;
                continue;
            }
            iCommonsList.addAll(iCommonsList2);
        } while (this.m_aParser.isPending());
        return iCommonsList;
    }

    @Nullable
    private String _getNextLine() throws IOException {
        if (this._isClosed()) {
            this.m_bHasNext = false;
            return null;
        }
        if (!this.m_bLinesSkiped) {
            for (int i = 0; i < this.m_nSkipLines; ++i) {
                this.m_aLineReader.readLine();
            }
            this.m_bLinesSkiped = true;
        }
        if (!this.m_bHasNext) {
            return null;
        }
        String string = this.m_aLineReader.readLine();
        if (string == null) {
            this.m_bHasNext = false;
        }
        return string;
    }

    private boolean _isClosed() {
        if (!this.m_bVerifyReader) {
            return false;
        }
        try {
            return !this.m_aReader.ready();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_aReader.close();
    }

    @Override
    @Nonnull
    public Iterator<ICommonsList<String>> iterator() {
        try {
            return new CSVIterator(this);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error creating CSVIterator", iOException);
        }
    }
}

