/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.state.ESuccess;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class PDTConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDTConfig.class);
    private static ZoneId s_aDefaultZoneId = TimeZone.getDefault().toZoneId();
    private static final PDTConfig INSTANCE = new PDTConfig();

    private PDTConfig() {
    }

    @Nonnull
    public static ESuccess setDefaultDateTimeZoneID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DateTimeZoneID");
        try {
            ZoneId zoneId = ZoneId.of(string);
            TimeZone timeZone = TimeZone.getTimeZone(zoneId);
            s_aDefaultZoneId = zoneId;
            TimeZone.setDefault(timeZone);
            return ESuccess.SUCCESS;
        }
        catch (DateTimeException dateTimeException) {
            LOGGER.warn("Unsupported ZoneId '" + string + "'", dateTimeException);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static ZoneId getDefaultZoneId() {
        return s_aDefaultZoneId;
    }

    @Nonnull
    public static ZoneId getUTCZoneId() {
        return ZoneOffset.UTC;
    }

    @Nonnull
    public static TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    @Nonnull
    public static TimeZone getUTCTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }
}

