/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.datetime;

import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTFormatPatterns {
    private static final PDTFormatPatterns INSTANCE = new PDTFormatPatterns();

    private PDTFormatPatterns() {
    }

    @Nonnull
    public static String getPatternDate(@Nonnull FormatStyle formatStyle, @Nonnull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, null, IsoChronology.INSTANCE, locale);
    }

    @Nonnull
    public static String getDefaultPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDate(locale);
    }

    @Nonnull
    public static String getShortPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.SHORT, locale);
    }

    @Nonnull
    public static String getMediumPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.MEDIUM, locale);
    }

    @Nonnull
    public static String getLongPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.LONG, locale);
    }

    @Nonnull
    public static String getFullPatternDate(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.FULL, locale);
    }

    @Nonnull
    public static String getPatternTime(@Nonnull FormatStyle formatStyle, @Nonnull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(null, formatStyle, IsoChronology.INSTANCE, locale);
    }

    @Nonnull
    public static String getDefaultPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternTime(locale);
    }

    @Nonnull
    public static String getShortPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.SHORT, locale);
    }

    @Nonnull
    public static String getMediumPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.MEDIUM, locale);
    }

    @Nonnull
    public static String getLongPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.LONG, locale);
    }

    @Nonnull
    public static String getFullPatternTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.FULL, locale);
    }

    @Nonnull
    public static String getPatternDateTime(@Nonnull FormatStyle formatStyle, @Nonnull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, formatStyle, IsoChronology.INSTANCE, locale);
    }

    @Nonnull
    public static String getDefaultPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDateTime(locale);
    }

    @Nonnull
    public static String getShortPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.SHORT, locale);
    }

    @Nonnull
    public static String getMediumPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.MEDIUM, locale);
    }

    @Nonnull
    public static String getLongPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.LONG, locale);
    }

    @Nonnull
    public static String getFullPatternDateTime(@Nonnull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.FULL, locale);
    }
}

