/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalQuery;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.datetime.OffsetDate;
import saoui.shade.com.helger.commons.datetime.XMLOffsetDate;
import saoui.shade.com.helger.commons.datetime.XMLOffsetDateTime;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

public class PDTMask<T extends Temporal> {
    private final String m_sPattern;
    private final TemporalQuery<T> m_aQuery;

    protected PDTMask(@Nonnull @Nonempty String string, @Nonnull TemporalQuery<T> temporalQuery) {
        ValueEnforcer.notEmpty(string, "Pattern");
        ValueEnforcer.notNull(temporalQuery, "Query");
        this.m_sPattern = string;
        this.m_aQuery = temporalQuery;
    }

    @Nonnull
    @Nonempty
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public TemporalQuery<T> getQuery() {
        return this.m_aQuery;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Pattern", this.m_sPattern).append("Query", this.m_aQuery).getToString();
    }

    @Nonnull
    public static PDTMask<ZonedDateTime> zonedDateTime(@Nonnull @Nonempty String string) {
        return new PDTMask<ZonedDateTime>(string, ZonedDateTime::from);
    }

    @Nonnull
    public static PDTMask<OffsetDateTime> offsetDateTime(@Nonnull @Nonempty String string) {
        return new PDTMask<OffsetDateTime>(string, OffsetDateTime::from);
    }

    @Nonnull
    public static PDTMask<XMLOffsetDateTime> xmlOffsetDateTime(@Nonnull @Nonempty String string) {
        return new PDTMask<XMLOffsetDateTime>(string, XMLOffsetDateTime::from);
    }

    @Nonnull
    public static PDTMask<LocalDateTime> localDateTime(@Nonnull @Nonempty String string) {
        return new PDTMask<LocalDateTime>(string, LocalDateTime::from);
    }

    @Nonnull
    public static PDTMask<OffsetDate> offsetDate(@Nonnull @Nonempty String string) {
        return new PDTMask<OffsetDate>(string, OffsetDate::from);
    }

    @Nonnull
    public static PDTMask<XMLOffsetDate> xmlOffsetDate(@Nonnull @Nonempty String string) {
        return new PDTMask<XMLOffsetDate>(string, XMLOffsetDate::from);
    }

    @Nonnull
    public static PDTMask<LocalDate> localDate(@Nonnull @Nonempty String string) {
        return new PDTMask<LocalDate>(string, LocalDate::from);
    }

    @Nonnull
    public static PDTMask<YearMonth> yearMonth(@Nonnull @Nonempty String string) {
        return new PDTMask<YearMonth>(string, YearMonth::from);
    }

    @Nonnull
    public static PDTMask<Year> year(@Nonnull @Nonempty String string) {
        return new PDTMask<Year>(string, Year::from);
    }
}

