/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.deadlock;

import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.deadlock.IThreadDeadlockCallback;
import saoui.shade.com.helger.commons.deadlock.ThreadDeadlockInfo;
import saoui.shade.com.helger.commons.lang.StackTraceHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

public class LoggingThreadDeadlockCallback
implements IThreadDeadlockCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingThreadDeadlockCallback.class);

    @Override
    public void onDeadlockDetected(@Nonnull ThreadDeadlockInfo[] threadDeadlockInfoArray) {
        if (LOGGER.isErrorEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(threadDeadlockInfoArray.length).append(" deadlocked threads:\n");
            for (ThreadDeadlockInfo threadDeadlockInfo : threadDeadlockInfoArray) {
                Thread thread = threadDeadlockInfo.getThread();
                stringBuilder.append('\n').append(thread.toString()).append(":\n").append(StackTraceHelper.getStackAsString(thread));
            }
            LOGGER.error(stringBuilder.toString());
        }
    }
}

