/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.deadlock;

import java.lang.management.ThreadInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
public class ThreadDeadlockInfo {
    private final ThreadInfo m_aThreadInfo;
    private final Thread m_aThread;
    private final StackTraceElement[] m_aStackTrace;

    public ThreadDeadlockInfo(@Nonnull ThreadInfo threadInfo, @Nonnull Thread thread, @Nullable StackTraceElement[] stackTraceElementArray) {
        this.m_aThreadInfo = ValueEnforcer.notNull(threadInfo, "ThreadInfo");
        this.m_aThread = ValueEnforcer.notNull(thread, "Thread");
        this.m_aStackTrace = ArrayHelper.getCopy(stackTraceElementArray);
    }

    @Nonnull
    public ThreadInfo getThreadInfo() {
        return this.m_aThreadInfo;
    }

    @Nonnull
    public Thread getThread() {
        return this.m_aThread;
    }

    public boolean hasStackTrace() {
        return this.m_aStackTrace != null;
    }

    @Nullable
    @ReturnsMutableCopy
    public StackTraceElement[] getAllStackTraceElements() {
        return ArrayHelper.getCopy(this.m_aStackTrace);
    }

    public String toString() {
        return new ToStringGenerator(this).append("threadInfo", this.m_aThreadInfo).append("thread", this.m_aThread).appendIfNotNull("stackTrace", this.m_aStackTrace).getToString();
    }
}

