/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.dimension;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.dimension.IHasDimensionFloat;
import saoui.shade.com.helger.commons.dimension.IHasDimensionInt;
import saoui.shade.com.helger.commons.dimension.IHasDimensionLong;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
public class SizeFloat
implements IHasDimensionFloat {
    private final float m_dWidth;
    private final float m_dHeight;

    public SizeFloat(@Nonnull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeFloat(@Nonnull IHasDimensionLong iHasDimensionLong) {
        this(iHasDimensionLong.getWidth(), iHasDimensionLong.getHeight());
    }

    public SizeFloat(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        this(iHasDimensionFloat.getWidth(), iHasDimensionFloat.getHeight());
    }

    public SizeFloat(@Nonnegative float f, @Nonnegative float f2) {
        this.m_dWidth = ValueEnforcer.isGE0(f, "Width");
        this.m_dHeight = ValueEnforcer.isGE0(f2, "Height");
    }

    @Override
    @Nonnegative
    public float getWidth() {
        return this.m_dWidth;
    }

    @Override
    @Nonnegative
    public float getHeight() {
        return this.m_dHeight;
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getBestMatchingSize(@Nonnegative float f, @Nonnegative float f2) {
        ValueEnforcer.isGT0(f, "MaxWidth");
        ValueEnforcer.isGT0(f2, "MaxHeight");
        float f3 = this.m_dWidth / f;
        float f4 = this.m_dHeight / f2;
        if (f3 > f4) {
            if (this.m_dWidth > f) {
                return new SizeFloat(f, this.m_dHeight / f3);
            }
        } else if (this.m_dHeight > f2) {
            return new SizeFloat(this.m_dWidth / f4, f2);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getScaledToWidth(@Nonnegative float f) {
        ValueEnforcer.isGT0(f, "NewWidth");
        if (this.m_dWidth == f) {
            return this;
        }
        float f2 = f / this.m_dWidth;
        return new SizeFloat(f, this.m_dHeight * f2);
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getScaledToHeight(@Nonnegative float f) {
        ValueEnforcer.isGT0(f, "NewHeight");
        if (this.m_dHeight == f) {
            return this;
        }
        float f2 = f / this.m_dHeight;
        return new SizeFloat(this.m_dWidth * f2, f);
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getAdded(@Nonnull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToAdd");
        return new SizeFloat(this.m_dWidth + (float)iHasDimensionInt.getWidth(), this.m_dHeight + (float)iHasDimensionInt.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getAdded(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToAdd");
        return new SizeFloat(this.m_dWidth + iHasDimensionFloat.getWidth(), this.m_dHeight + iHasDimensionFloat.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getSubtracted(@Nonnull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToSubtract");
        return new SizeFloat(this.m_dWidth - (float)iHasDimensionInt.getWidth(), this.m_dHeight - (float)iHasDimensionInt.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeFloat getSubtracted(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToSubtract");
        return new SizeFloat(this.m_dWidth - iHasDimensionFloat.getWidth(), this.m_dHeight - iHasDimensionFloat.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeFloat sizeFloat = (SizeFloat)object;
        return EqualsHelper.equals(this.m_dWidth, sizeFloat.m_dWidth) && EqualsHelper.equals(this.m_dHeight, sizeFloat.m_dHeight);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dWidth).append(this.m_dHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_dWidth).append("height", this.m_dHeight).getToString();
    }
}

