/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.error.level;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.error.level.EErrorLevel;
import saoui.shade.com.helger.commons.id.IHasID;
import saoui.shade.com.helger.commons.severity.ISeverityComparable;
import saoui.shade.com.helger.commons.state.IErrorIndicator;
import saoui.shade.com.helger.commons.state.ISuccessIndicator;

@MustImplementEqualsAndHashcode
public interface IErrorLevel
extends IHasID<String>,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<IErrorLevel> {
    @Nonnegative
    public int getNumericLevel();

    @Override
    default public boolean isSuccess() {
        return this.isEQ(EErrorLevel.SUCCESS);
    }

    @Override
    default public boolean isFailure() {
        return this.isGT(EErrorLevel.SUCCESS);
    }

    @Override
    default public boolean isError() {
        return this.isGE(EErrorLevel.ERROR);
    }

    @Override
    default public boolean isNoError() {
        return this.isLT(EErrorLevel.ERROR);
    }

    default public int compareTo(@Nonnull IErrorLevel iErrorLevel) {
        return Integer.compare(this.getNumericLevel(), iErrorLevel.getNumericLevel());
    }

    @Override
    default public boolean isEQ(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() == iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isNE(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() != iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLT(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() < iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isLE(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() <= iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isGT(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() > iErrorLevel.getNumericLevel();
    }

    @Override
    default public boolean isGE(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() >= iErrorLevel.getNumericLevel();
    }

    default public boolean isHighest() {
        return this.isEQ(EErrorLevel.HIGHEST);
    }

    @Nullable
    public static IErrorLevel getMostSevere(@Nullable IErrorLevel iErrorLevel, @Nullable IErrorLevel iErrorLevel2) {
        if (EqualsHelper.identityEqual(iErrorLevel, iErrorLevel2)) {
            return iErrorLevel;
        }
        if (iErrorLevel == null) {
            return iErrorLevel2;
        }
        if (iErrorLevel2 == null) {
            return iErrorLevel;
        }
        return iErrorLevel.isGT(iErrorLevel2) ? iErrorLevel : iErrorLevel2;
    }
}

