/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.error.text;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.error.text.IHasErrorText;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.text.IHasText;
import saoui.shade.com.helger.commons.text.display.IHasDisplayText;

@Immutable
@MustImplementEqualsAndHashcode
public class DynamicHasErrorText
implements IHasErrorText {
    private final IHasText m_aText;

    public DynamicHasErrorText(@Nonnull IHasDisplayText iHasDisplayText) {
        this(iHasDisplayText.getAsHasText());
    }

    public DynamicHasErrorText(@Nonnull IHasText iHasText) {
        this.m_aText = ValueEnforcer.notNull(iHasText, "Text");
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getText(locale);
    }

    @Override
    public boolean isMultiLingual() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DynamicHasErrorText dynamicHasErrorText = (DynamicHasErrorText)object;
        return EqualsHelper.equals(this.m_aText, dynamicHasErrorText.m_aText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("MLT", this.m_aText).getToString();
    }
}

