/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.format;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.format.AbstractFormatterString;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

public class FormatterStringSkipPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringSkipPrefixAndSuffix(@Nonnull String string, @Nonnull String string2) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
        this.m_sSuffix = ValueEnforcer.notNull(string2, "Suffix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (this.m_sPrefix.length() > 0) {
            string = StringHelper.trimStart(string, this.m_sPrefix);
        }
        if (this.m_sSuffix.length() > 0) {
            string = StringHelper.trimEnd(string, this.m_sSuffix);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringSkipPrefixAndSuffix formatterStringSkipPrefixAndSuffix = (FormatterStringSkipPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringSkipPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringSkipPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Prefix", this.m_sPrefix).append("Suffix", this.m_sSuffix).getToString();
    }

    @Nonnull
    public static FormatterStringSkipPrefixAndSuffix createPrefixOnly(@Nonnull String string) {
        return new FormatterStringSkipPrefixAndSuffix(string, "");
    }

    @Nonnull
    public static FormatterStringSkipPrefixAndSuffix createSuffixOnly(@Nonnull String string) {
        return new FormatterStringSkipPrefixAndSuffix("", string);
    }
}

