/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.functional;

import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.functional.ICharPredicate;

@Immutable
public final class Predicates {
    private Predicates() {
    }

    @Nonnull
    public static <DATATYPE> Predicate<DATATYPE> all() {
        return object -> true;
    }

    @Nonnull
    public static <DATATYPE> Predicate<DATATYPE> none() {
        return object -> false;
    }

    @Nonnull
    public static <DATATYPE> Predicate<DATATYPE> notNull() {
        return Objects::nonNull;
    }

    @Nonnull
    public static <DATATYPE> Predicate<DATATYPE> isNull() {
        return Objects::isNull;
    }

    @Nonnull
    public static ICharPredicate charIsEQ0() {
        return c -> c == '\u0000';
    }

    @Nonnull
    public static ICharPredicate charIsNE0() {
        return c -> c != '\u0000';
    }

    @Nonnull
    public static ICharPredicate charIsGT0() {
        return c -> c > '\u0000';
    }

    @Nonnull
    public static DoublePredicate doubleIsLT0() {
        return d -> d < 0.0;
    }

    @Nonnull
    public static DoublePredicate doubleIsLE0() {
        return d -> d <= 0.0;
    }

    @Nonnull
    public static DoublePredicate doubleIsEQ0() {
        return d -> d == 0.0;
    }

    @Nonnull
    public static DoublePredicate doubleIsNE0() {
        return d -> d != 0.0;
    }

    @Nonnull
    public static DoublePredicate doubleIsGE0() {
        return d -> d >= 0.0;
    }

    @Nonnull
    public static DoublePredicate doubleIsGT0() {
        return d -> d > 0.0;
    }

    @Nonnull
    public static IntPredicate intIsLT0() {
        return n -> n < 0;
    }

    @Nonnull
    public static IntPredicate intIsLE0() {
        return n -> n <= 0;
    }

    @Nonnull
    public static IntPredicate intIsEQ0() {
        return n -> n == 0;
    }

    @Nonnull
    public static IntPredicate intIsNE0() {
        return n -> n != 0;
    }

    @Nonnull
    public static IntPredicate intIsGE0() {
        return n -> n >= 0;
    }

    @Nonnull
    public static IntPredicate intIsGT0() {
        return n -> n > 0;
    }

    @Nonnull
    public static LongPredicate longIsLT0() {
        return l -> l < 0L;
    }

    @Nonnull
    public static LongPredicate longIsLE0() {
        return l -> l <= 0L;
    }

    @Nonnull
    public static LongPredicate longIsEQ0() {
        return l -> l == 0L;
    }

    @Nonnull
    public static LongPredicate longIsNE0() {
        return l -> l != 0L;
    }

    @Nonnull
    public static LongPredicate longIsGE0() {
        return l -> l >= 0L;
    }

    @Nonnull
    public static LongPredicate longIsGT0() {
        return l -> l > 0L;
    }

    @Nullable
    public static <T> Predicate<T> and(@Nullable Predicate<? super T> predicate, @Nullable Predicate<? super T> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test(object) && predicate2.test(object);
            }
            return predicate::test;
        }
        if (predicate2 != null) {
            return predicate2::test;
        }
        return null;
    }

    @Nullable
    public static <T> Predicate<T> or(@Nullable Predicate<? super T> predicate, @Nullable Predicate<? super T> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test(object) || predicate2.test(object);
            }
            return predicate::test;
        }
        if (predicate2 != null) {
            return predicate2::test;
        }
        return null;
    }
}

