/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.hierarchy;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.collection.impl.ICommonsCollection;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.hierarchy.IChildrenProvider;

@Immutable
public class ChildrenProviderSorting<CHILDTYPE>
implements IChildrenProvider<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final Comparator<? super CHILDTYPE> m_aComparator;

    public ChildrenProviderSorting(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull Comparator<? super CHILDTYPE> comparator) {
        this.m_aChildrenProvider = ValueEnforcer.notNull(iChildrenProvider, "ChildrenProvider");
        this.m_aComparator = ValueEnforcer.notNull(comparator, "Comparator");
    }

    @Nonnull
    public IChildrenProvider<CHILDTYPE> getChildrenProvider() {
        return this.m_aChildrenProvider;
    }

    @Nonnull
    public Comparator<? super CHILDTYPE> getComparator() {
        return this.m_aComparator;
    }

    @Override
    public final boolean hasChildren(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.hasChildren(CHILDTYPE);
    }

    @Override
    public final int getChildCount(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.getChildCount(CHILDTYPE);
    }

    @Override
    @Nullable
    public ICommonsList<? extends CHILDTYPE> getAllChildren(@Nullable CHILDTYPE CHILDTYPE) {
        ICommonsCollection<CHILDTYPE> iCommonsCollection = this.m_aChildrenProvider.getAllChildren(CHILDTYPE);
        return iCommonsCollection == null ? null : iCommonsCollection.getSorted(this.m_aComparator);
    }
}

