/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.hierarchy;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.ICommonsCollection;
import saoui.shade.com.helger.commons.collection.impl.ICommonsIterable;
import saoui.shade.com.helger.commons.state.EContinue;

public interface IHasChildren<CHILDTYPE> {
    default public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    default public boolean hasNoChildren() {
        return !this.hasChildren();
    }

    @Nonnegative
    public int getChildCount();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsCollection<? extends CHILDTYPE> getAllChildren();

    @Nullable
    public ICommonsIterable<? extends CHILDTYPE> getChildren();

    default public void forAllChildren(@Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().forEach(consumer);
        }
    }

    @Nonnull
    default public EContinue forAllChildrenBreakable(@Nonnull Function<? super CHILDTYPE, EContinue> function) {
        if (this.hasChildren()) {
            return this.getChildren().forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    default public void forAllChildren(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAll(predicate, consumer);
        }
    }

    default public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Function<? super CHILDTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAllMapped(predicate, function, consumer);
        }
    }
}

