/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.http;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.lang.EnumHelper;
import saoui.shade.com.helger.commons.name.IHasName;

public enum EHttpMethod implements IHasName
{
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT"),
    PATCH("PATCH");

    private final String m_sName;

    private EHttpMethod(String string2) {
        this.m_sName = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean isIdempodent() {
        return this == GET || this == HEAD || this == PUT || this == DELETE || this == OPTIONS || this == TRACE;
    }

    public boolean isContentAllowed() {
        return this != HEAD;
    }

    public boolean isPayloadInBody() {
        return this == POST || this == PUT || this == PATCH;
    }

    @Nullable
    public static EHttpMethod getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EHttpMethod.class, string);
    }

    @Nullable
    public static EHttpMethod getFromNameOrDefault(@Nullable String string, @Nullable EHttpMethod eHttpMethod) {
        return EnumHelper.getFromNameOrDefault(EHttpMethod.class, string, eHttpMethod);
    }
}

