/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.id.factory;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.id.factory.IIntIDFactory;
import saoui.shade.com.helger.commons.id.factory.ILongIDFactory;
import saoui.shade.com.helger.commons.id.factory.IStringIDFactory;
import saoui.shade.com.helger.commons.id.factory.MemoryIntIDFactory;
import saoui.shade.com.helger.commons.id.factory.MemoryLongIDFactory;
import saoui.shade.com.helger.commons.id.factory.StringIDFromGlobalIntIDFactory;
import saoui.shade.com.helger.commons.id.factory.StringIDFromGlobalPersistentIntIDFactory;
import saoui.shade.com.helger.commons.state.EChange;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalIDFactory {
    public static final String DEFAULT_PREFIX = "id";
    public static final int STRING_ID_MAX_LENGTH = 20;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIDFactory.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static IIntIDFactory s_aIntIDFactory = new MemoryIntIDFactory();
    private static IIntIDFactory s_aPersistentIntIDFactory;
    private static ILongIDFactory s_aLongIDFactory;
    private static ILongIDFactory s_aPersistentLongIDFactory;
    private static IStringIDFactory s_aStringIDFactory;
    private static IStringIDFactory s_aPersistentStringIDFactory;
    private static final GlobalIDFactory INSTANCE;

    private GlobalIDFactory() {
    }

    public static boolean hasIntIDFactory() {
        return GlobalIDFactory.getIntIDFactory() != null;
    }

    @Nullable
    public static IIntIDFactory getIntIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aIntIDFactory);
    }

    @Nonnull
    public static EChange setIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aIntIDFactory, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory int ID factory " + iIntIDFactory);
            }
            s_aIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentIntIDFactory() {
        return GlobalIDFactory.getPersistentIntIDFactory() != null;
    }

    @Nullable
    public static IIntIDFactory getPersistentIntIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentIntIDFactory);
    }

    @Nonnull
    public static EChange setPersistentIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aPersistentIntIDFactory, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent int ID factory " + iIntIDFactory);
            }
            s_aPersistentIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasLongIDFactory() {
        return GlobalIDFactory.getLongIDFactory() != null;
    }

    @Nullable
    public static ILongIDFactory getLongIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aLongIDFactory);
    }

    @Nonnull
    public static EChange setLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aLongIDFactory, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory long ID factory " + iLongIDFactory);
            }
            s_aLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentLongIDFactory() {
        return GlobalIDFactory.getPersistentLongIDFactory() != null;
    }

    @Nullable
    public static ILongIDFactory getPersistentLongIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentLongIDFactory);
    }

    @Nonnull
    public static EChange setPersistentLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aPersistentLongIDFactory, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent long ID factory " + iLongIDFactory);
            }
            s_aPersistentLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasStringIDFactory() {
        return GlobalIDFactory.getStringIDFactory() != null;
    }

    @Nullable
    public static IStringIDFactory getStringIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aStringIDFactory);
    }

    @Nonnull
    public static EChange setStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aStringIDFactory, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory string ID factory " + iStringIDFactory);
            }
            s_aStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentStringIDFactory() {
        return GlobalIDFactory.getPersistentStringIDFactory() != null;
    }

    @Nullable
    public static IStringIDFactory getPersistentStringIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentStringIDFactory);
    }

    @Nonnull
    public static EChange setPersistentStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            if (EqualsHelper.equals(s_aPersistentStringIDFactory, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent string ID factory " + iStringIDFactory);
            }
            s_aPersistentStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static int getNewIntID() {
        return RW_LOCK.readLockedInt(() -> {
            IIntIDFactory iIntIDFactory = s_aIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            return iIntIDFactory.getNewID();
        });
    }

    public static int getNewPersistentIntID() {
        return RW_LOCK.readLockedInt(() -> {
            IIntIDFactory iIntIDFactory = s_aPersistentIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return iIntIDFactory.getNewID();
        });
    }

    public static long getNewLongID() {
        return RW_LOCK.readLockedLong(() -> {
            ILongIDFactory iLongIDFactory = s_aLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            return iLongIDFactory.getNewID();
        });
    }

    public static long getNewPersistentLongID() {
        return RW_LOCK.readLockedLong(() -> {
            ILongIDFactory iLongIDFactory = s_aPersistentLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return iLongIDFactory.getNewID();
        });
    }

    @Nonnull
    public static String getNewStringID() {
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String string = (String)iStringIDFactory.getNewID();
            if (string.length() > 20) {
                throw new IllegalStateException("The created String ID has a length of " + string.length() + " which exceeds the maximum allowed length of " + 20);
            }
            return string;
        });
    }

    @Nonnull
    public static String getNewPersistentStringID() {
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aPersistentStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String string = (String)iStringIDFactory.getNewID();
            if (string.length() > 20) {
                throw new IllegalStateException("The created String ID has a length of " + string.length() + " which exceeds the maximum allowed length of " + 20);
            }
            return string;
        });
    }

    public static int[] getBulkNewIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IIntIDFactory iIntIDFactory = s_aIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = iIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static int[] getBulkNewPersistentIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IIntIDFactory iIntIDFactory = s_aPersistentIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = iIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static long[] getBulkNewLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            ILongIDFactory iLongIDFactory = s_aLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = iLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    public static long[] getBulkNewPersistentLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            ILongIDFactory iLongIDFactory = s_aPersistentLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = iLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    @Nonnull
    public static String[] getBulkNewStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)iStringIDFactory.getNewID();
                if (stringArray[i].length() <= 20) continue;
                throw new IllegalStateException("The created String ID has a length of " + stringArray[i].length() + " which exceeds the maximum allowed length of " + 20);
            }
            return stringArray;
        });
    }

    @Nonnull
    public static String[] getBulkNewPersistentStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aPersistentStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)iStringIDFactory.getNewID();
                if (stringArray[i].length() <= 20) continue;
                throw new IllegalStateException("The created String ID has a length of " + stringArray[i].length() + " which exceeds the maximum allowed length of " + 20);
            }
            return stringArray;
        });
    }

    static {
        s_aLongIDFactory = new MemoryLongIDFactory();
        s_aStringIDFactory = new StringIDFromGlobalIntIDFactory();
        s_aPersistentStringIDFactory = new StringIDFromGlobalPersistentIntIDFactory();
        INSTANCE = new GlobalIDFactory();
    }
}

