/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.provider;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.io.EAppend;
import saoui.shade.com.helger.commons.io.file.FileHelper;
import saoui.shade.com.helger.commons.io.provider.IInputStreamProvider;
import saoui.shade.com.helger.commons.io.provider.IOutputStreamProvider;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
public class FileSystemByteStreamProvider
implements IInputStreamProvider,
IOutputStreamProvider {
    private final File m_aBasePath;

    public FileSystemByteStreamProvider(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemByteStreamProvider(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BasePath");
        ValueEnforcer.isTrue(file.exists(), () -> "Base path does not exist: " + file);
        ValueEnforcer.isTrue(file.isDirectory(), () -> "Only directories are allowed as base path: " + file);
        this.m_aBasePath = file;
    }

    @Nonnull
    public File getBasePath() {
        return this.m_aBasePath;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        return FileHelper.getInputStream(new File(this.m_aBasePath, string));
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileHelper.getOutputStream(new File(this.m_aBasePath, string), eAppend);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemByteStreamProvider fileSystemByteStreamProvider = (FileSystemByteStreamProvider)object;
        return this.m_aBasePath.equals(fileSystemByteStreamProvider.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).getToString();
    }
}

