/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.relative;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.io.EAppend;
import saoui.shade.com.helger.commons.io.file.FileIOError;
import saoui.shade.com.helger.commons.io.file.FileOperationManager;
import saoui.shade.com.helger.commons.io.file.FilenameHelper;
import saoui.shade.com.helger.commons.io.relative.IPathRelativeIO;
import saoui.shade.com.helger.commons.io.resource.FileSystemResource;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;
import saoui.shade.com.helger.commons.state.ESuccess;

public interface IFileRelativeIO
extends IPathRelativeIO {
    @Nonnull
    public File getBasePathFile();

    @Override
    @Nonnull
    @Nonempty
    default public String getBasePath() {
        return this.getBasePathFile().getAbsolutePath();
    }

    @Nonnull
    default public File getFile(@Nonnull String string) {
        return new File(this.getBasePathFile(), string);
    }

    @Override
    @Nonnull
    default public FileSystemResource getResource(@Nonnull String string) {
        return new FileSystemResource(this.getFile(string));
    }

    @Nullable
    default public String getRelativeFilename(@Nonnull File file) {
        return FilenameHelper.getRelativeToParentDirectory(file, this.getBasePathFile());
    }

    default public boolean existsFile(@Nonnull String string) {
        return this.getFile(string).isFile();
    }

    default public boolean existsDir(@Nonnull String string) {
        return this.getFile(string).isDirectory();
    }

    @Nullable
    default public OutputStream getOutputStream(@Nonnull String string) {
        return this.getOutputStream(string, EAppend.TRUNCATE);
    }

    @Nullable
    default public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return this.getResource(string).getOutputStream(eAppend);
    }

    @Nullable
    default public Writer getWriter(@Nonnull String string, @Nonnull Charset charset) {
        return this.getWriter(string, charset, EAppend.TRUNCATE);
    }

    @Nullable
    default public Writer getWriter(@Nonnull String string, @Nonnull Charset charset, @Nonnull EAppend eAppend) {
        return this.getResource(string).getWriter(charset, eAppend);
    }

    @Nonnull
    default public FileIOError createDirectory(@Nonnull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file) : FileOperationManager.INSTANCE.createDirIfNotExisting(file);
    }

    @Nonnull
    default public FileIOError deleteDirectory(@Nonnull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.deleteDirRecursive(file) : FileOperationManager.INSTANCE.deleteDir(file);
    }

    @Nonnull
    default public FileIOError deleteDirectoryIfExisting(@Nonnull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.deleteDirRecursiveIfExisting(file) : FileOperationManager.INSTANCE.deleteDirIfExisting(file);
    }

    @Nonnull
    default public FileIOError deleteFile(@Nonnull String string) {
        return FileOperationManager.INSTANCE.deleteFile(this.getFile(string));
    }

    @Nonnull
    default public FileIOError deleteFileIfExisting(@Nonnull String string) {
        return FileOperationManager.INSTANCE.deleteFileIfExisting(this.getFile(string));
    }

    @Nonnull
    default public FileIOError renameDir(@Nonnull String string, @Nonnull String string2) {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        return FileOperationManager.INSTANCE.renameDir(file, file2);
    }

    @Nonnull
    default public FileIOError renameFile(@Nonnull String string, @Nonnull String string2) {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        return FileOperationManager.INSTANCE.renameFile(file, file2);
    }

    @Nonnull
    default public ESuccess writeFile(@Nonnull String string, @Nonnull EAppend eAppend, @Nonnull byte[] byArray) {
        OutputStream outputStream = this.getOutputStream(string, eAppend);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return StreamHelper.writeStream(outputStream, byArray);
    }

    @Nonnull
    default public ESuccess saveFile(@Nonnull String string, @Nonnull String string2, @Nonnull Charset charset) {
        return this.saveFile(string, string2.getBytes(charset));
    }

    @Nonnull
    default public ESuccess saveFile(@Nonnull String string, byte[] byArray) {
        return this.writeFile(string, EAppend.TRUNCATE, byArray);
    }

    @Nonnull
    default public ESuccess appendFile(@Nonnull String string, @Nonnull String string2, @Nonnull Charset charset) {
        return this.appendFile(string, string2.getBytes(charset));
    }

    @Nonnull
    default public ESuccess appendFile(@Nonnull String string, @Nonnull byte[] byArray) {
        return this.writeFile(string, EAppend.APPEND, byArray);
    }
}

