/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.relative;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.io.file.FileHelper;
import saoui.shade.com.helger.commons.io.file.FilenameHelper;
import saoui.shade.com.helger.commons.io.relative.IPathRelativeIO;
import saoui.shade.com.helger.commons.io.resource.IReadableResource;
import saoui.shade.com.helger.commons.io.resourceresolver.DefaultResourceResolver;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
public class PathRelativeIO
implements IPathRelativeIO {
    private final String m_sBasePath;
    private final String m_sBaseURL;

    public PathRelativeIO(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "BasePath");
        this.m_sBasePath = string;
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            string2 = FileHelper.getAsURLString(file);
        }
        this.m_sBaseURL = string2 != null ? string2 : string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getBasePath() {
        return this.m_sBasePath;
    }

    @Nonnull
    @Nonempty
    public String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Override
    @Nonnull
    public IReadableResource getResource(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "RelativePath");
        String string2 = FilenameHelper.startsWithPathSeparatorChar(string) ? string.substring(1) : string;
        return DefaultResourceResolver.getResolvedResource(string2, this.m_sBaseURL);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathRelativeIO pathRelativeIO = (PathRelativeIO)object;
        return this.m_sBasePath.equals(pathRelativeIO.m_sBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("BasePath", this.m_sBasePath).append("BaseURL", this.m_sBaseURL).getToString();
    }
}

