/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.io.resource.IReadableResource;
import saoui.shade.com.helger.commons.io.resource.URLResource;
import saoui.shade.com.helger.commons.io.stream.StreamHelper;
import saoui.shade.com.helger.commons.lang.ClassLoaderHelper;
import saoui.shade.com.helger.commons.lang.IHasClassLoader;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.com.helger.commons.url.URLHelper;

@NotThreadSafe
public class ClassPathResource
implements IReadableResource,
IHasClassLoader {
    public static final String CLASSPATH_PREFIX_LONG = "classpath:";
    public static final String CLASSPATH_PREFIX_SHORT = "cp:";
    private String m_sPath;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bURLResolved = false;
    private URL m_aURL;

    public ClassPathResource(@Nonnull URL uRL) {
        this(uRL, null);
    }

    public ClassPathResource(@Nonnull URL uRL, @Nullable ClassLoader classLoader) {
        this(uRL.toExternalForm(), classLoader);
    }

    public ClassPathResource(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public ClassPathResource(@Nonnull @Nonempty String string, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmpty(string, "Path");
        this.m_sPath = ClassPathResource.getWithoutClassPathPrefix(string);
        if (StringHelper.hasNoText(this.m_sPath)) {
            throw new IllegalArgumentException("No path specified after prefix: " + string);
        }
        this.m_aClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aClassLoader != null) {
            throw new IOException("Cannot serialize a ClassPathResource that has a specific ClassLoader!");
        }
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sPath);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sPath = StreamHelper.readSafeUTF(objectInputStream);
    }

    @Nullable
    public static String getWithoutClassPathPrefix(@Nullable String string) {
        if (StringHelper.startsWith(string, CLASSPATH_PREFIX_LONG)) {
            return string.substring(CLASSPATH_PREFIX_LONG.length());
        }
        if (StringHelper.startsWith(string, CLASSPATH_PREFIX_SHORT)) {
            return string.substring(CLASSPATH_PREFIX_SHORT.length());
        }
        return string;
    }

    public static boolean isExplicitClassPathResource(@Nullable String string) {
        return StringHelper.startsWith(string, CLASSPATH_PREFIX_LONG) || StringHelper.startsWith(string, CLASSPATH_PREFIX_SHORT);
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.m_aClassLoader == null ? null : (ClassLoader)this.m_aClassLoader.get();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        URL uRL = this.getAsURL();
        return uRL == null ? this.m_sPath : uRL.toExternalForm();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    private static InputStream _getInputStream(@Nonnull @Nonempty String string, @Nullable URL uRL, @Nullable ClassLoader classLoader) {
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = ClassLoaderHelper.getResourceAsStream(classLoader, string);
        } else if (uRL != null) {
            inputStream = URLResource.getInputStream(uRL);
        }
        return inputStream;
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL(string);
        return ClassPathResource._getInputStream(string, uRL, null);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = ClassLoaderHelper.getResource(classLoader, string);
        return ClassPathResource._getInputStream(string, uRL, null);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        URL uRL = this.getAsURL();
        return ClassPathResource._getInputStream(this.m_sPath, uRL, this.getClassLoader());
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    @Nullable
    public InputStream getInputStreamNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return ClassPathResource._getInputStream(this.m_sPath, uRL, classLoader);
    }

    @Nullable
    public Reader getReaderNoCache(@Nonnull ClassLoader classLoader, @Nonnull Charset charset) {
        return StreamHelper.createReader(this.getInputStreamNoCache(classLoader), charset);
    }

    @Override
    public boolean exists() {
        return this.getAsURL() != null;
    }

    @Nullable
    private URL _getAsURL() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return URLHelper.getClassPathURL(this.m_sPath);
        }
        String string = this.m_sPath;
        return ClassLoaderHelper.getResource(classLoader, string);
    }

    public boolean existsNoCacheUsage() {
        return this._getAsURL() != null;
    }

    @Override
    @Nullable
    public URL getAsURL() {
        if (!this.m_bURLResolved) {
            this.m_aURL = this._getAsURL();
            this.m_bURLResolved = true;
        }
        return this.m_aURL;
    }

    @Nullable
    public URL getAsURLNoCache(@Nonnull ClassLoader classLoader) {
        String string = this.m_sPath;
        return ClassLoaderHelper.getResource(classLoader, string);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL(string);
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = ClassLoaderHelper.getResource(classLoader, string);
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Override
    @Nullable
    public File getAsFile() {
        URL uRL = this.getAsURL();
        return URLHelper.getAsFileOrNull(uRL);
    }

    @Nullable
    public File getAsFileNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return URLHelper.getAsFileOrNull(uRL);
    }

    public boolean canRead() {
        return this.getAsURL() != null;
    }

    public boolean canReadNoCache(@Nonnull ClassLoader classLoader) {
        return this.getAsURLNoCache(classLoader) != null;
    }

    @Override
    @Nonnull
    public ClassPathResource getReadableCloneForPath(@Nonnull String string) {
        return new ClassPathResource(string, this.getClassLoader());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassPathResource classPathResource = (ClassPathResource)object;
        return EqualsHelper.equals(this.m_sPath, classPathResource.m_sPath) && EqualsHelper.equals(this.getClassLoader(), classPathResource.getClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).append(this.getClassLoader()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("cpPath", this.m_sPath).appendIfNotNull("classLoader", this.getClassLoader()).append("urlResolved", this.m_bURLResolved).append("URL", this.m_aURL).getToString();
    }
}

