/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.resource.wrapped;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.io.resource.IReadableResource;
import saoui.shade.com.helger.commons.io.resource.wrapped.AbstractWrappedReadableResource;

public class GZIPReadableResource
extends AbstractWrappedReadableResource {
    public GZIPReadableResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        InputStream inputStream = this.getWrappedReadableResource().getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP InputStream", iOException);
        }
    }

    @Override
    @Nonnull
    public GZIPReadableResource getReadableCloneForPath(@Nonnull String string) {
        return new GZIPReadableResource(this.getWrappedReadableResource().getReadableCloneForPath(string));
    }
}

