/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.resourceprovider;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.equals.EqualsHelper;
import saoui.shade.com.helger.commons.hashcode.HashCodeGenerator;
import saoui.shade.com.helger.commons.io.resource.ClassPathResource;
import saoui.shade.com.helger.commons.io.resource.FileSystemResource;
import saoui.shade.com.helger.commons.io.resource.IReadableResource;
import saoui.shade.com.helger.commons.io.resource.IWritableResource;
import saoui.shade.com.helger.commons.io.resource.URLResource;
import saoui.shade.com.helger.commons.io.resourceprovider.IWritableResourceProvider;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public class FileSystemResourceProvider
implements IWritableResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResourceProvider.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final File m_aBasePath;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bCanReadRelativePaths = false;

    public FileSystemResourceProvider() {
        this((File)null);
    }

    public FileSystemResourceProvider(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemResourceProvider(@Nullable File file) {
        if (file != null) {
            ValueEnforcer.isTrue(file.exists(), () -> "Passed base path '" + file + "' does not exist!");
            ValueEnforcer.isTrue(file.isDirectory(), () -> "Passed base path '" + file + "' is not a directory!");
            if (!file.canRead() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot read passed base path '" + file + "'!");
            }
            if (!file.canWrite() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot write passed base path '" + file + "'!");
            }
            if (!file.canExecute() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot execute in passed base path '" + file + "'!");
            }
        }
        this.m_aBasePath = file;
    }

    @Nullable
    public final File getBasePath() {
        return this.m_aBasePath;
    }

    public final boolean isCanReadRelativePaths() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bCanReadRelativePaths);
    }

    @Nonnull
    public final FileSystemResourceProvider setCanReadRelativePaths(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bCanReadRelativePaths = bl;
            return this.m_bCanReadRelativePaths;
        });
        return this;
    }

    @Nonnull
    private File _getFile(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return this.m_aBasePath == null ? new File(string) : new File(this.m_aBasePath, string);
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(string)) {
            return false;
        }
        if (this.isCanReadRelativePaths()) {
            return true;
        }
        return this._getFile(string).isAbsolute();
    }

    @Override
    public boolean supportsWriting(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        return !URLResource.isExplicitURLResource(string);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    @Override
    @Nonnull
    public IWritableResource getWritableResource(@Nonnull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemResourceProvider fileSystemResourceProvider = (FileSystemResourceProvider)object;
        return EqualsHelper.equals(this.m_aBasePath, fileSystemResourceProvider.m_aBasePath) && this.m_bCanReadRelativePaths == fileSystemResourceProvider.m_bCanReadRelativePaths;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).append(this.m_bCanReadRelativePaths).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("BasePath", this.m_aBasePath).append("CanReadRelativePaths", this.m_bCanReadRelativePaths).getToString();
    }
}

