/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.resourceresolver;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.io.file.FilenameHelper;
import saoui.shade.com.helger.commons.io.resource.ClassPathResource;
import saoui.shade.com.helger.commons.io.resource.FileSystemResource;
import saoui.shade.com.helger.commons.io.resource.IReadableResource;
import saoui.shade.com.helger.commons.io.resource.URLResource;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.url.URLHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@Immutable
public class DefaultResourceResolver {
    private static final AtomicBoolean DEBUG_RESOLVE = new AtomicBoolean(false);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceResolver.class);

    protected DefaultResourceResolver() {
    }

    public static boolean isDebugResolve() {
        return DEBUG_RESOLVE.get();
    }

    public static void setDebugResolve(boolean bl) {
        DEBUG_RESOLVE.set(bl);
    }

    public static boolean isExplicitJarFileResource(@Nullable String string) {
        return StringHelper.startsWith(string, "jar:file:") || StringHelper.startsWith(string, "wsjar:file:") || StringHelper.startsWith(string, "zip:file:");
    }

    @Nonnull
    public static IReadableResource getResolvedResource(@Nullable String string, @Nullable String string2) {
        return DefaultResourceResolver.getResolvedResource(string, string2, null);
    }

    @Nonnull
    private static ClassPathResource _resolveClassPathResource(String string, String string2, ClassLoader classLoader) {
        String string3 = ClassPathResource.getWithoutClassPathPrefix(string2);
        File file = new File(string3).getParentFile();
        String string4 = FilenameHelper.getCleanPath(file == null ? string : file.getPath() + '/' + string);
        ClassPathResource classPathResource = new ClassPathResource(string4, classLoader);
        if (DefaultResourceResolver.isDebugResolve() && LOGGER.isInfoEnabled()) {
            LOGGER.info("  [ClassPath] resolved base + system to " + classPathResource);
        }
        return classPathResource;
    }

    @Nonnull
    private static URLResource _resolveJarFileResource(@Nonnull String string, @Nonnull String string2) throws MalformedURLException {
        File file;
        String string3;
        String string4;
        int n = string2.lastIndexOf("!/");
        if (n < 0) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n + 2);
            string3 = string2.substring(n + 2);
        }
        if (FilenameHelper.startsWithPathSeparatorChar(string3)) {
            string3 = string3.substring(1);
        }
        String string5 = FilenameHelper.getCleanPath((file = new File(string3).getParentFile()) == null ? string : file.getPath() + '/' + string);
        String string6 = string4.endsWith("/") && string5.startsWith("/") ? string4 + string5.substring(1) : string4 + string5;
        URLResource uRLResource = new URLResource(string6);
        if (DefaultResourceResolver.isDebugResolve() && LOGGER.isInfoEnabled()) {
            LOGGER.info("  [JarFile] resolved base + system to " + uRLResource);
        }
        return uRLResource;
    }

    @Nonnull
    private static URLResource _resolveURLResource(String string, URL uRL) throws MalformedURLException {
        String string2 = uRL.getPath();
        String string3 = FilenameHelper.getWithoutPath(string2);
        if (string3 != null && string3.indexOf(46) >= 0) {
            string2 = FilenameHelper.getPath(string2);
        }
        String string4 = FilenameHelper.getCleanConcatenatedUrlPath(string2, string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), URLHelper.getURLString(string4, uRL.getQuery(), uRL.getRef()));
        URLResource uRLResource = new URLResource(uRL2);
        if (DefaultResourceResolver.isDebugResolve() && LOGGER.isInfoEnabled()) {
            LOGGER.info("  [URL] resolved base + system to " + uRLResource);
        }
        return uRLResource;
    }

    @Nonnull
    private static FileSystemResource _getChildResource(@Nullable File file, @Nonnull File file2) {
        if (file == null) {
            return new FileSystemResource(file2);
        }
        File file3 = file.isDirectory() ? file : file.getParentFile();
        File file4 = new File(file3, file2.getPath());
        return new FileSystemResource(file4);
    }

    @Nonnull
    public static IReadableResource getResolvedResource(@Nullable String string, @Nullable String string2, @Nullable ClassLoader classLoader) {
        URL uRL;
        if (StringHelper.hasNoText(string) && StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("Both systemID and baseURI are null!");
        }
        boolean bl = DefaultResourceResolver.isDebugResolve();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to resolve resource " + string + " from base " + string2 + (classLoader == null ? "" : " with ClassLoader " + classLoader));
        }
        if (bl && LOGGER.isInfoEnabled()) {
            LOGGER.info("doStandardResourceResolving ('" + string + "', '" + string2 + "', " + classLoader + ")");
        }
        if ((uRL = URLHelper.getAsURL(string, false)) != null && !uRL.getProtocol().equals("file")) {
            URLResource uRLResource = new URLResource(uRL);
            if (bl && LOGGER.isInfoEnabled()) {
                LOGGER.info("  resolved system URL to " + uRLResource);
            }
            return uRLResource;
        }
        if (ClassPathResource.isExplicitClassPathResource(string2)) {
            return DefaultResourceResolver._resolveClassPathResource(string, string2, classLoader);
        }
        if (DefaultResourceResolver.isExplicitJarFileResource(string2)) {
            try {
                return DefaultResourceResolver._resolveJarFileResource(string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        URL uRL2 = URLHelper.getAsURL(string2);
        if (uRL2 != null && !uRL2.getProtocol().equals("file")) {
            try {
                return DefaultResourceResolver._resolveURLResource(string, uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        File file = uRL2 != null ? URLHelper.getAsFile(uRL2) : (string2 != null ? new File(string2) : null);
        if (StringHelper.hasNoText(string)) {
            FileSystemResource fileSystemResource = new FileSystemResource(file);
            if (bl && LOGGER.isInfoEnabled()) {
                LOGGER.info("  resolved base URL to " + fileSystemResource);
            }
            return fileSystemResource;
        }
        File file2 = uRL != null ? URLHelper.getAsFile(uRL) : new File(string);
        if (file2.isAbsolute()) {
            FileSystemResource fileSystemResource;
            FileSystemResource fileSystemResource2 = new FileSystemResource(file2);
            if (!fileSystemResource2.exists() && (fileSystemResource = DefaultResourceResolver._getChildResource(file, file2)).exists()) {
                if (bl && LOGGER.isInfoEnabled()) {
                    LOGGER.info("  resolved base + system URL to " + fileSystemResource);
                }
                return fileSystemResource;
            }
            if (bl && LOGGER.isInfoEnabled()) {
                LOGGER.info("  resolved system URL to " + fileSystemResource2);
            }
            return fileSystemResource2;
        }
        FileSystemResource fileSystemResource = DefaultResourceResolver._getChildResource(file, file2);
        if (bl && LOGGER.isInfoEnabled()) {
            LOGGER.info("  resolved base + system URL to " + fileSystemResource);
        }
        return fileSystemResource;
    }
}

