/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.ArrayHelper;
import saoui.shade.com.helger.commons.io.ByteArrayWrapper;
import saoui.shade.com.helger.commons.io.IWriteToStream;
import saoui.shade.com.helger.commons.io.stream.NonBlockingByteArrayInputStream;

public class ByteBufferOutputStream
extends OutputStream
implements IWriteToStream {
    public static final int DEFAULT_BUF_SIZE = 1024;
    public static final boolean DEFAULT_CAN_GROW = true;
    private ByteBuffer m_aBuffer;
    private final boolean m_bCanGrow;

    public ByteBufferOutputStream() {
        this(1024, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n) {
        this(n, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n, boolean bl) {
        this(ByteBuffer.allocate(n), bl);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray) {
        this(ByteBuffer.wrap(byArray), false);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public ByteBufferOutputStream(@Nonnull ByteBuffer byteBuffer, boolean bl) {
        ValueEnforcer.notNull(byteBuffer, "Buffer");
        this.m_aBuffer = byteBuffer;
        this.m_bCanGrow = bl;
    }

    @Nonnull
    public ByteBuffer getBuffer() {
        return this.m_aBuffer;
    }

    public boolean canGrow() {
        return this.m_bCanGrow;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.m_aBuffer.clear();
    }

    @Nonnegative
    public int size() {
        return this.m_aBuffer.position();
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAsByteArray() {
        byte[] byArray = this.m_aBuffer.array();
        int n = this.m_aBuffer.arrayOffset();
        int n2 = this.m_aBuffer.position();
        return ArrayHelper.getCopy(byArray, n, n2);
    }

    @Nonnull
    public NonBlockingByteArrayInputStream getAsByteArrayInputStream(boolean bl) {
        byte[] byArray = this.m_aBuffer.array();
        int n = this.m_aBuffer.arrayOffset();
        int n2 = this.m_aBuffer.position();
        return new NonBlockingByteArrayInputStream(byArray, n, n2, bl);
    }

    @Nonnull
    public ByteArrayWrapper getAsByteArrayWrapper(boolean bl) {
        byte[] byArray = this.m_aBuffer.array();
        int n = this.m_aBuffer.arrayOffset();
        int n2 = this.m_aBuffer.position();
        return new ByteArrayWrapper(byArray, n, n2, bl);
    }

    public void writeTo(@Nonnull ByteBuffer byteBuffer) {
        this.writeTo(byteBuffer, true);
    }

    public void writeTo(@Nonnull ByteBuffer byteBuffer, boolean bl) {
        ValueEnforcer.notNull(byteBuffer, "DestBuffer");
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        if (bl) {
            this.m_aBuffer.compact();
        }
    }

    public void writeTo(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Buffer");
        this.writeTo(byArray, 0, byArray.length, true);
    }

    public void writeTo(@Nonnull byte[] byArray, boolean bl) {
        ValueEnforcer.notNull(byArray, "Buffer");
        this.writeTo(byArray, 0, byArray.length, bl);
    }

    public void writeTo(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this.writeTo(byArray, n, n2, true);
    }

    public void writeTo(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBuffer.flip();
        this.m_aBuffer.get(byArray, n, n2);
        if (bl) {
            this.m_aBuffer.compact();
        }
    }

    @Override
    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, true);
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream, boolean bl) throws IOException {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        outputStream.write(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position());
        if (bl) {
            this.m_aBuffer.clear();
        }
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return new String(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position(), charset);
    }

    private void _growBy(@Nonnegative int n) {
        int n2 = this.m_aBuffer.capacity();
        int n3 = Math.max(n2 << 1, n2 + n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        this.m_aBuffer = byteBuffer;
    }

    @Override
    public void write(int n) {
        if (this.m_bCanGrow && !this.m_aBuffer.hasRemaining()) {
            this._growBy(1);
        }
        this.m_aBuffer.put((byte)n);
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bCanGrow && n2 > this.m_aBuffer.remaining()) {
            this._growBy(n2);
        }
        this.m_aBuffer.put(byArray, n, n2);
    }

    public void write(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "SourceBuffer");
        if (this.m_bCanGrow && byteBuffer.remaining() > this.m_aBuffer.remaining()) {
            this._growBy(byteBuffer.remaining());
        }
        this.m_aBuffer.put(byteBuffer);
    }
}

