/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.stream;

import java.io.InputStream;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.io.IHasInputStream;
import saoui.shade.com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import saoui.shade.com.helger.commons.string.ToStringGenerator;

@Immutable
public class HasInputStream
implements IHasInputStream {
    private final Supplier<? extends InputStream> m_aISP;
    private final boolean m_bReadMultiple;

    public HasInputStream(@Nonnull Supplier<? extends InputStream> supplier, boolean bl) {
        this.m_aISP = ValueEnforcer.notNull(supplier, "ISP");
        this.m_bReadMultiple = bl;
    }

    @Override
    public final boolean isReadMultiple() {
        return this.m_bReadMultiple;
    }

    @Override
    public final InputStream getInputStream() {
        return this.m_aISP.get();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("ReadMultiple", this.m_bReadMultiple).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream multiple(@Nonnull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream once(@Nonnull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, false);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IHasInputStream create(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        ValueEnforcer.notNull(nonBlockingByteArrayOutputStream, "BAOS");
        return new HISNBBAOS(nonBlockingByteArrayOutputStream);
    }

    private static final class HISNBBAOS
    implements IHasInputStream {
        private final NonBlockingByteArrayOutputStream m_aBAOS;

        public HISNBBAOS(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
            this.m_aBAOS = nonBlockingByteArrayOutputStream;
        }

        @Override
        @Nonnull
        public InputStream getInputStream() {
            return this.m_aBAOS.getAsInputStream();
        }

        @Override
        public boolean isReadMultiple() {
            return true;
        }
    }
}

