/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.io.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import saoui.shade.com.helger.commons.annotation.OverrideOnDemand;
import saoui.shade.com.helger.commons.io.stream.WrappedInputStream;
import saoui.shade.com.helger.commons.string.ToStringGenerator;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

public class LoggingInputStream
extends WrappedInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingInputStream.class);
    private long m_nPosition = 0L;

    public LoggingInputStream(@Nonnull InputStream inputStream) {
        super(inputStream);
    }

    public final long getPosition() {
        return this.m_nPosition;
    }

    @OverrideOnDemand
    protected void onRead(int n, long l) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Read " + n + " byte(s); now at " + l);
        }
    }

    @OverrideOnDemand
    protected void onSkip(long l, long l2) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Skipped " + l + " byte(s); now at " + l2);
        }
    }

    @OverrideOnDemand
    protected void onMark(int n, long l) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Marked at " + l + " with read-limit of " + n);
        }
    }

    @OverrideOnDemand
    protected void onReset(long l) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Reset at " + l);
        }
    }

    @OverrideOnDemand
    protected void onClose(long l) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Close at " + l);
        }
    }

    @Override
    public final int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nPosition;
            this.onRead(1, this.m_nPosition);
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.m_nPosition += (long)n3;
            this.onRead(n3, this.m_nPosition);
        }
        return n3;
    }

    @Override
    public final long skip(@Nonnegative long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.m_nPosition += l2;
            this.onSkip(l2, this.m_nPosition);
        }
        return l2;
    }

    @Override
    public final synchronized void mark(@Nonnegative int n) {
        super.mark(n);
        this.onMark(n, this.m_nPosition);
    }

    @Override
    public final synchronized void reset() throws IOException {
        super.reset();
        this.onReset(this.m_nPosition);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.onClose(this.m_nPosition);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("position", this.m_nPosition).getToString();
    }
}

