/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.lang;

import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;

@Immutable
public final class BitSetHelper {
    private static final BitSetHelper INSTANCE = new BitSetHelper();

    private BitSetHelper() {
    }

    @Nonnull
    public static BitSet createBitSet(byte by) {
        BitSet bitSet = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            bitSet.set(i, (by >> i & 1) == 1);
        }
        return bitSet;
    }

    @Nonnull
    public static BitSet createBitSet(short s) {
        BitSet bitSet = new BitSet(16);
        for (int i = 0; i < 16; ++i) {
            bitSet.set(i, (s >> i & 1) == 1);
        }
        return bitSet;
    }

    @Nonnull
    public static BitSet createBitSet(int n) {
        BitSet bitSet = new BitSet(32);
        for (int i = 0; i < 32; ++i) {
            bitSet.set(i, (n >> i & 1) == 1);
        }
        return bitSet;
    }

    @Nonnull
    public static BitSet createBitSet(long l) {
        BitSet bitSet = new BitSet(64);
        for (int i = 0; i < 64; ++i) {
            bitSet.set(i, (l >> i & 1L) == 1L);
        }
        return bitSet;
    }

    public static int getExtractedIntValue(@Nonnull BitSet bitSet) {
        ValueEnforcer.notNull(bitSet, "BitSet");
        int n = bitSet.length();
        ValueEnforcer.isTrue(n <= 32, () -> "Can extract only up to 32 bits");
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n2 <<= 1;
            if (!bitSet.get(i)) continue;
            ++n2;
        }
        return n2;
    }

    public static long getExtractedLongValue(@Nonnull BitSet bitSet) {
        ValueEnforcer.notNull(bitSet, "BitSet");
        int n = bitSet.length();
        ValueEnforcer.isTrue(n <= 64, () -> "Can extract only up to 64 bits");
        long l = 0L;
        for (int i = n - 1; i >= 0; --i) {
            l <<= 1;
            if (!bitSet.get(i)) continue;
            ++l;
        }
        return l;
    }
}

