/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.lang;

import java.io.PrintStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.com.helger.commons.system.ENewLineMode;
import saoui.shade.com.helger.commons.system.SystemProperties;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper INSTANCE = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllClassPathEntries() {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        ClassPathHelper.forAllClassPathEntries(commonsArrayList::add);
        return commonsArrayList;
    }

    public static void forAllClassPathEntries(@Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        StringHelper.explode(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), consumer);
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream, @Nonnull String string) {
        ClassPathHelper.forAllClassPathEntries(string2 -> {
            printStream.print((String)string2);
            printStream.print(string);
        });
    }
}

