/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.lang;

import java.security.Permission;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;

@Immutable
public final class SecurityManagerHelper {
    private SecurityManagerHelper() {
    }

    @Nonnull
    public static ThreadGroup getThreadGroup() {
        SecurityManager securityManager = System.getSecurityManager();
        return securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public static void checkPermission(@Nonnull Permission permission) {
        ValueEnforcer.notNull(permission, "Permission");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

