/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.lang;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import saoui.shade.com.helger.commons.ValueEnforcer;
import saoui.shade.com.helger.commons.annotation.IsSPIImplementation;
import saoui.shade.com.helger.commons.annotation.IsSPIInterface;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.cache.AnnotationUsageCache;
import saoui.shade.com.helger.commons.collection.impl.CommonsArrayList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.lang.ClassLoaderHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@Immutable
public final class ServiceLoaderHelper {
    public static final AnnotationUsageCache CACHE_INTERFACE = new AnnotationUsageCache(IsSPIInterface.class);
    public static final AnnotationUsageCache CACHE_IMPLEMENTATION = new AnnotationUsageCache(IsSPIImplementation.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderHelper.class);

    private ServiceLoaderHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2;
        ValueEnforcer.notNull(clazz, "SPIClass");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        Logger logger3 = logger2 = logger != null ? logger : LOGGER;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Trying to retrieve all SPI implementations of " + clazz);
        }
        if (!CACHE_INTERFACE.hasAnnotation(clazz) && LOGGER.isWarnEnabled()) {
            LOGGER.warn(clazz + " should have the @IsSPIInterface annotation");
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                T t = iterator.next();
                if (!CACHE_IMPLEMENTATION.hasAnnotation(t) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn(t + " should have the @IsSPIImplementation annotation");
                }
                commonsArrayList.add(t);
            }
            catch (Exception exception) {
                logger2.error("Unable to load an SPI implementation of " + clazz, exception);
            }
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("Finished retrieving all " + commonsArrayList.size() + " SPI implementations of " + clazz);
        }
        return commonsArrayList;
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, classLoader, null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2 = logger != null ? logger : LOGGER;
        ICommonsList<T> iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, logger2);
        if (iCommonsList.isEmpty()) {
            return null;
        }
        if (iCommonsList.size() > 1 && logger2.isWarnEnabled()) {
            logger2.warn("Requested only one SPI implementation of " + clazz + " but found " + iCommonsList.size() + " - using the first one. Details: " + iCommonsList);
        }
        return iCommonsList.getFirst();
    }
}

