/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.locale;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import saoui.shade.com.helger.commons.annotation.ReturnsMutableCopy;
import saoui.shade.com.helger.commons.collection.impl.CommonsHashSet;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashMap;
import saoui.shade.com.helger.commons.collection.impl.CommonsLinkedHashSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsList;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedMap;
import saoui.shade.com.helger.commons.collection.impl.ICommonsOrderedSet;
import saoui.shade.com.helger.commons.collection.impl.ICommonsSet;
import saoui.shade.com.helger.commons.concurrent.SimpleReadWriteLock;
import saoui.shade.com.helger.commons.locale.LocaleHelper;
import saoui.shade.com.helger.commons.string.StringHelper;
import saoui.shade.org.slf4j.Logger;
import saoui.shade.org.slf4j.LoggerFactory;

@ThreadSafe
public class LocaleCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleCache.class);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<String, Locale> m_aLocales = new CommonsLinkedHashMap<String, Locale>();
    private final IMissingLocaleHandler m_aMissingLocaleHandlerInsert = (string, string2, string3, string4) -> {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.writeLockedGet(() -> this.m_aLocales.computeIfAbsent(string, string4 -> new Locale(string2, string3, string4)));
    };

    protected LocaleCache() {
        this.reinitialize();
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static LocaleCache getInstance() {
        LocaleCache localeCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return localeCache;
    }

    @Nonnull
    public final IMissingLocaleHandler getDefaultMissingLocaleHandler() {
        return this.m_aMissingLocaleHandlerInsert;
    }

    @Nullable
    public Locale getLocale(@Nullable String string) {
        return this.getLocaleExt(string, this.m_aMissingLocaleHandlerInsert);
    }

    @Nullable
    public Locale getLocaleExt(@Nullable String string, @Nullable IMissingLocaleHandler iMissingLocaleHandler) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.getLocale(stringArray[0], stringArray[1], stringArray[2], iMissingLocaleHandler);
            }
            if (stringArray.length == 2) {
                return this.getLocale(stringArray[0], stringArray[1], "", iMissingLocaleHandler);
            }
        }
        return this.getLocale(string, "", "", iMissingLocaleHandler);
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2) {
        return this.getLocale(string, string2, "");
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        return this.getLocale(string, string2, string3, this.m_aMissingLocaleHandlerInsert);
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable IMissingLocaleHandler iMissingLocaleHandler) {
        String string4 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull(string3);
        String string7 = LocaleCache._buildLocaleString(string4, string5, string6);
        Locale locale = null;
        if (string7.length() > 0) {
            locale = this.m_aRWLock.readLockedGet(() -> (Locale)this.m_aLocales.get(string7));
        }
        if (locale == null && iMissingLocaleHandler != null) {
            locale = iMissingLocaleHandler.onMissingLocale(string7, string4, string5, string6);
        }
        return locale;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Locale> getAllLocales() {
        ICommonsList iCommonsList = this.m_aRWLock.readLockedGet(this.m_aLocales::copyOfValues);
        iCommonsList.remove(LocaleHelper.LOCALE_ALL);
        iCommonsList.remove(LocaleHelper.LOCALE_INDEPENDENT);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllLanguages() {
        CommonsHashSet<Locale> commonsHashSet = new CommonsHashSet<Locale>();
        for (Locale locale : this.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            commonsHashSet.add(this.getLocale(string, null, null));
        }
        return commonsHashSet;
    }

    public boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return this.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return this.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return this.containsLocale(string, "", "");
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return this.containsLocale(string, string2, "");
    }

    @Nonnull
    private static String _createLocaleKey(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.getNotNull(LocaleHelper.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull(LocaleHelper.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull(string3);
        return LocaleCache._buildLocaleString(string4, string5, string6);
    }

    public boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = LocaleCache._createLocaleKey(string, string2, string3);
        if (string4.length() == 0) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aLocales.containsKey(string4));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<Locale> getAllDefaultLocales() {
        CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(1024);
        commonsLinkedHashSet.add(LocaleHelper.LOCALE_ALL);
        commonsLinkedHashSet.add(LocaleHelper.LOCALE_INDEPENDENT);
        for (Locale object : Locale.getAvailableLocales()) {
            commonsLinkedHashSet.add(object);
            String string = object.getCountry();
            String string2 = object.getLanguage();
            if (!StringHelper.hasText(string) || !StringHelper.hasText(string2)) continue;
            commonsLinkedHashSet.add(new Locale("", string));
            commonsLinkedHashSet.add(new Locale(string2, ""));
        }
        for (String string : Locale.getISOCountries()) {
            commonsLinkedHashSet.add(new Locale("", string));
        }
        for (String string : Locale.getISOLanguages()) {
            commonsLinkedHashSet.add(new Locale(string, ""));
        }
        return commonsLinkedHashSet;
    }

    public final void reinitialize() {
        ICommonsOrderedSet<Locale> iCommonsOrderedSet = LocaleCache.getAllDefaultLocales();
        this.m_aRWLock.writeLocked(() -> {
            this.m_aLocales.clear();
            for (Locale locale : iCommonsOrderedSet) {
                this.m_aLocales.put(locale.toString(), locale);
            }
        });
        if (!LocaleCache.isSilentMode() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + LocaleCache.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final LocaleCache INSTANCE = new LocaleCache();

        private SingletonHolder() {
        }
    }

    @FunctionalInterface
    public static interface IMissingLocaleHandler {
        @Nullable
        public Locale onMissingLocale(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);
    }
}

