/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.location;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import saoui.shade.com.helger.commons.string.StringHelper;

@MustImplementEqualsAndHashcode
public interface ILocation {
    public static final int ILLEGAL_NUMBER = -1;

    @Nullable
    public String getResourceID();

    default public boolean hasResourceID() {
        return StringHelper.hasText(this.getResourceID());
    }

    public int getLineNumber();

    default public boolean hasLineNumber() {
        return this.getLineNumber() > -1;
    }

    public int getColumnNumber();

    default public boolean hasColumnNumber() {
        return this.getColumnNumber() > -1;
    }

    default public boolean isAnyInformationPresent() {
        return this.hasResourceID() || this.hasLineNumber() || this.hasColumnNumber();
    }

    @Nonnull
    default public String getAsString() {
        String string = "";
        String string2 = this.getResourceID();
        if (StringHelper.hasText(string2)) {
            string = string + string2;
        }
        if (this.hasLineNumber()) {
            string = this.hasColumnNumber() ? string + "(" + this.getLineNumber() + ":" + this.getColumnNumber() + ")" : string + "(" + this.getLineNumber() + ":?)";
        } else if (this.hasColumnNumber()) {
            string = string + "(?:" + this.getColumnNumber() + ")";
        }
        return string;
    }
}

