/*
 * Decompiled with CFR 0.152.
 */
package saoui.shade.com.helger.commons.mime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import saoui.shade.com.helger.commons.annotation.Nonempty;
import saoui.shade.com.helger.commons.id.IHasID;
import saoui.shade.com.helger.commons.lang.EnumHelper;
import saoui.shade.com.helger.commons.mime.MimeType;
import saoui.shade.com.helger.commons.string.StringHelper;

public enum EMimeContentType implements IHasID<String>
{
    APPLICATION("application"),
    AUDIO("audio"),
    EXAMPLE("example"),
    FONT("font"),
    IMAGE("image"),
    MESSAGE("message"),
    MODEL("model"),
    MULTIPART("multipart"),
    TEXT("text"),
    VIDEO("video"),
    CHEMICAL("chemical"),
    FLV_APPLICATION("flv-application"),
    INODE("inode"),
    WWW("www"),
    X_CONFERENCE("x-conference"),
    X_CONTENT("x-content"),
    X_DIRECTORY("x-directory"),
    X_EPOC("x-epoc"),
    X_WORLD("x-world"),
    ZZ_APPLICATION("zz-application"),
    _STAR("*");

    private final String m_sText;

    private EMimeContentType(String string2) {
        this.m_sText = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sText;
    }

    @Nonnull
    @Nonempty
    public String getText() {
        return this.m_sText;
    }

    @Nonnull
    public MimeType buildMimeType(@Nonnull @Nonempty String string) {
        return new MimeType(this, string);
    }

    public boolean isTypeOf(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return false;
        }
        return this.m_sText.equalsIgnoreCase(string.substring(0, n));
    }

    @Nullable
    public static EMimeContentType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrNull(EMimeContentType.class, string);
    }
}

